/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentDetails implements SdkPojo, Serializable, ToCopyableBuilder<AgentDetails.Builder, AgentDetails> {
    private static final SdkField<List<Integer>> AGENT_CPU_CORES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("agentCpuCores")
            .getter(getter(AgentDetails::agentCpuCores))
            .setter(setter(Builder::agentCpuCores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCpuCores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentDetails::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<List<ComponentVersion>> COMPONENT_VERSIONS_FIELD = SdkField
            .<List<ComponentVersion>> builder(MarshallingType.LIST)
            .memberName("componentVersions")
            .getter(getter(AgentDetails::componentVersions))
            .setter(setter(Builder::componentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(AgentDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(AgentDetails::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<List<Integer>> RESERVED_CPU_CORES_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("reservedCpuCores")
            .getter(getter(AgentDetails::reservedCpuCores))
            .setter(setter(Builder::reservedCpuCores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedCpuCores").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_CPU_CORES_FIELD,
            AGENT_VERSION_FIELD, COMPONENT_VERSIONS_FIELD, INSTANCE_ID_FIELD, INSTANCE_TYPE_FIELD, RESERVED_CPU_CORES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Integer> agentCpuCores;

    private final String agentVersion;

    private final List<ComponentVersion> componentVersions;

    private final String instanceId;

    private final String instanceType;

    private final List<Integer> reservedCpuCores;

    private AgentDetails(BuilderImpl builder) {
        this.agentCpuCores = builder.agentCpuCores;
        this.agentVersion = builder.agentVersion;
        this.componentVersions = builder.componentVersions;
        this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.reservedCpuCores = builder.reservedCpuCores;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentCpuCores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentCpuCores() {
        return agentCpuCores != null && !(agentCpuCores instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of CPU cores reserved for the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentCpuCores} method.
     * </p>
     * 
     * @return List of CPU cores reserved for the agent.
     */
    public final List<Integer> agentCpuCores() {
        return agentCpuCores;
    }

    /**
     * <p>
     * Current agent version.
     * </p>
     * 
     * @return Current agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentVersions() {
        return componentVersions != null && !(componentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of versions being used by agent components.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentVersions} method.
     * </p>
     * 
     * @return List of versions being used by agent components.
     */
    public final List<ComponentVersion> componentVersions() {
        return componentVersions;
    }

    /**
     * <p>
     * ID of EC2 instance agent is running on.
     * </p>
     * 
     * @return ID of EC2 instance agent is running on.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Type of EC2 instance agent is running on.
     * </p>
     * 
     * @return Type of EC2 instance agent is running on.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedCpuCores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReservedCpuCores() {
        return reservedCpuCores != null && !(reservedCpuCores instanceof SdkAutoConstructList);
    }

    /**
     * <note>
     * <p>
     * This field should not be used. Use agentCpuCores instead.
     * </p>
     * </note>
     * <p>
     * List of CPU cores reserved for processes other than the agent running on the EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedCpuCores} method.
     * </p>
     * 
     * @return <p>
     *         This field should not be used. Use agentCpuCores instead.
     *         </p>
     *         </note>
     *         <p>
     *         List of CPU cores reserved for processes other than the agent running on the EC2 instance.
     */
    public final List<Integer> reservedCpuCores() {
        return reservedCpuCores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentCpuCores() ? agentCpuCores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentVersions() ? componentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasReservedCpuCores() ? reservedCpuCores() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentDetails)) {
            return false;
        }
        AgentDetails other = (AgentDetails) obj;
        return hasAgentCpuCores() == other.hasAgentCpuCores() && Objects.equals(agentCpuCores(), other.agentCpuCores())
                && Objects.equals(agentVersion(), other.agentVersion()) && hasComponentVersions() == other.hasComponentVersions()
                && Objects.equals(componentVersions(), other.componentVersions())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(instanceType(), other.instanceType())
                && hasReservedCpuCores() == other.hasReservedCpuCores()
                && Objects.equals(reservedCpuCores(), other.reservedCpuCores());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentDetails").add("AgentCpuCores", hasAgentCpuCores() ? agentCpuCores() : null)
                .add("AgentVersion", agentVersion())
                .add("ComponentVersions", hasComponentVersions() ? componentVersions() : null).add("InstanceId", instanceId())
                .add("InstanceType", instanceType()).add("ReservedCpuCores", hasReservedCpuCores() ? reservedCpuCores() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentCpuCores":
            return Optional.ofNullable(clazz.cast(agentCpuCores()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "componentVersions":
            return Optional.ofNullable(clazz.cast(componentVersions()));
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "reservedCpuCores":
            return Optional.ofNullable(clazz.cast(reservedCpuCores()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentDetails, T> g) {
        return obj -> g.apply((AgentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentDetails> {
        /**
         * <p>
         * List of CPU cores reserved for the agent.
         * </p>
         * 
         * @param agentCpuCores
         *        List of CPU cores reserved for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCpuCores(Collection<Integer> agentCpuCores);

        /**
         * <p>
         * List of CPU cores reserved for the agent.
         * </p>
         * 
         * @param agentCpuCores
         *        List of CPU cores reserved for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCpuCores(Integer... agentCpuCores);

        /**
         * <p>
         * Current agent version.
         * </p>
         * 
         * @param agentVersion
         *        Current agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * List of versions being used by agent components.
         * </p>
         * 
         * @param componentVersions
         *        List of versions being used by agent components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersions(Collection<ComponentVersion> componentVersions);

        /**
         * <p>
         * List of versions being used by agent components.
         * </p>
         * 
         * @param componentVersions
         *        List of versions being used by agent components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersions(ComponentVersion... componentVersions);

        /**
         * <p>
         * List of versions being used by agent components.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentVersion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #componentVersions(List<ComponentVersion>)}.
         * 
         * @param componentVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.ComponentVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentVersions(java.util.Collection<ComponentVersion>)
         */
        Builder componentVersions(Consumer<ComponentVersion.Builder>... componentVersions);

        /**
         * <p>
         * ID of EC2 instance agent is running on.
         * </p>
         * 
         * @param instanceId
         *        ID of EC2 instance agent is running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Type of EC2 instance agent is running on.
         * </p>
         * 
         * @param instanceType
         *        Type of EC2 instance agent is running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <note>
         * <p>
         * This field should not be used. Use agentCpuCores instead.
         * </p>
         * </note>
         * <p>
         * List of CPU cores reserved for processes other than the agent running on the EC2 instance.
         * </p>
         * 
         * @param reservedCpuCores
         *        <p>
         *        This field should not be used. Use agentCpuCores instead.
         *        </p>
         *        </note>
         *        <p>
         *        List of CPU cores reserved for processes other than the agent running on the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCpuCores(Collection<Integer> reservedCpuCores);

        /**
         * <note>
         * <p>
         * This field should not be used. Use agentCpuCores instead.
         * </p>
         * </note>
         * <p>
         * List of CPU cores reserved for processes other than the agent running on the EC2 instance.
         * </p>
         * 
         * @param reservedCpuCores
         *        <p>
         *        This field should not be used. Use agentCpuCores instead.
         *        </p>
         *        </note>
         *        <p>
         *        List of CPU cores reserved for processes other than the agent running on the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCpuCores(Integer... reservedCpuCores);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> agentCpuCores = DefaultSdkAutoConstructList.getInstance();

        private String agentVersion;

        private List<ComponentVersion> componentVersions = DefaultSdkAutoConstructList.getInstance();

        private String instanceId;

        private String instanceType;

        private List<Integer> reservedCpuCores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentDetails model) {
            agentCpuCores(model.agentCpuCores);
            agentVersion(model.agentVersion);
            componentVersions(model.componentVersions);
            instanceId(model.instanceId);
            instanceType(model.instanceType);
            reservedCpuCores(model.reservedCpuCores);
        }

        public final Collection<Integer> getAgentCpuCores() {
            if (agentCpuCores instanceof SdkAutoConstructList) {
                return null;
            }
            return agentCpuCores;
        }

        public final void setAgentCpuCores(Collection<Integer> agentCpuCores) {
            this.agentCpuCores = AgentCpuCoresListCopier.copy(agentCpuCores);
        }

        @Override
        public final Builder agentCpuCores(Collection<Integer> agentCpuCores) {
            this.agentCpuCores = AgentCpuCoresListCopier.copy(agentCpuCores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentCpuCores(Integer... agentCpuCores) {
            agentCpuCores(Arrays.asList(agentCpuCores));
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final List<ComponentVersion.Builder> getComponentVersions() {
            List<ComponentVersion.Builder> result = ComponentVersionListCopier.copyToBuilder(this.componentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentVersions(Collection<ComponentVersion.BuilderImpl> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copyFromBuilder(componentVersions);
        }

        @Override
        public final Builder componentVersions(Collection<ComponentVersion> componentVersions) {
            this.componentVersions = ComponentVersionListCopier.copy(componentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(ComponentVersion... componentVersions) {
            componentVersions(Arrays.asList(componentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentVersions(Consumer<ComponentVersion.Builder>... componentVersions) {
            componentVersions(Stream.of(componentVersions).map(c -> ComponentVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Collection<Integer> getReservedCpuCores() {
            if (reservedCpuCores instanceof SdkAutoConstructList) {
                return null;
            }
            return reservedCpuCores;
        }

        public final void setReservedCpuCores(Collection<Integer> reservedCpuCores) {
            this.reservedCpuCores = AgentCpuCoresListCopier.copy(reservedCpuCores);
        }

        @Override
        public final Builder reservedCpuCores(Collection<Integer> reservedCpuCores) {
            this.reservedCpuCores = AgentCpuCoresListCopier.copy(reservedCpuCores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedCpuCores(Integer... reservedCpuCores) {
            reservedCpuCores(Arrays.asList(reservedCpuCores));
            return this;
        }

        @Override
        public AgentDetails build() {
            return new AgentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
