/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentConfigurationResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetAgentConfigurationResponse.Builder, GetAgentConfigurationResponse> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(GetAgentConfigurationResponse::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> TASKING_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskingDocument").getter(getter(GetAgentConfigurationResponse::taskingDocument))
            .setter(setter(Builder::taskingDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskingDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            TASKING_DOCUMENT_FIELD));

    private final String agentId;

    private final String taskingDocument;

    private GetAgentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.taskingDocument = builder.taskingDocument;
    }

    /**
     * <p>
     * UUID of agent.
     * </p>
     * 
     * @return UUID of agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Tasking document for agent.
     * </p>
     * 
     * @return Tasking document for agent.
     */
    public final String taskingDocument() {
        return taskingDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(taskingDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentConfigurationResponse)) {
            return false;
        }
        GetAgentConfigurationResponse other = (GetAgentConfigurationResponse) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(taskingDocument(), other.taskingDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentConfigurationResponse").add("AgentId", agentId())
                .add("TaskingDocument", taskingDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "taskingDocument":
            return Optional.ofNullable(clazz.cast(taskingDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAgentConfigurationResponse, T> g) {
        return obj -> g.apply((GetAgentConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentConfigurationResponse> {
        /**
         * <p>
         * UUID of agent.
         * </p>
         * 
         * @param agentId
         *        UUID of agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Tasking document for agent.
         * </p>
         * 
         * @param taskingDocument
         *        Tasking document for agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskingDocument(String taskingDocument);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String agentId;

        private String taskingDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentConfigurationResponse model) {
            super(model);
            agentId(model.agentId);
            taskingDocument(model.taskingDocument);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getTaskingDocument() {
            return taskingDocument;
        }

        public final void setTaskingDocument(String taskingDocument) {
            this.taskingDocument = taskingDocument;
        }

        @Override
        public final Builder taskingDocument(String taskingDocument) {
            this.taskingDocument = taskingDocument;
            return this;
        }

        @Override
        public GetAgentConfigurationResponse build() {
            return new GetAgentConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
