/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.services.groundstation.model.MissionProfileListCopier;
import software.amazon.awssdk.services.groundstation.model.MissionProfileListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMissionProfilesResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListMissionProfilesResponse> {
    private static final SdkField<List<MissionProfileListItem>> MISSION_PROFILE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("missionProfileList").getter(ListMissionProfilesResponse.getter(ListMissionProfilesResponse::missionProfileList)).setter(ListMissionProfilesResponse.setter(Builder::missionProfileList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MissionProfileListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMissionProfilesResponse.getter(ListMissionProfilesResponse::nextToken)).setter(ListMissionProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<MissionProfileListItem> missionProfileList;
    private final String nextToken;

    private ListMissionProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.missionProfileList = builder.missionProfileList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMissionProfileList() {
        return this.missionProfileList != null && !(this.missionProfileList instanceof SdkAutoConstructList);
    }

    public final List<MissionProfileListItem> missionProfileList() {
        return this.missionProfileList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMissionProfileList() ? this.missionProfileList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMissionProfilesResponse)) {
            return false;
        }
        ListMissionProfilesResponse other = (ListMissionProfilesResponse)((Object)obj);
        return this.hasMissionProfileList() == other.hasMissionProfileList() && Objects.equals(this.missionProfileList(), other.missionProfileList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMissionProfilesResponse").add("MissionProfileList", this.hasMissionProfileList() ? this.missionProfileList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "missionProfileList": {
                return Optional.ofNullable(clazz.cast(this.missionProfileList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMissionProfilesResponse, T> g) {
        return obj -> g.apply((ListMissionProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private List<MissionProfileListItem> missionProfileList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMissionProfilesResponse model) {
            super(model);
            this.missionProfileList(model.missionProfileList);
            this.nextToken(model.nextToken);
        }

        public final List<MissionProfileListItem.Builder> getMissionProfileList() {
            List<MissionProfileListItem.Builder> result = MissionProfileListCopier.copyToBuilder(this.missionProfileList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMissionProfileList(Collection<MissionProfileListItem.BuilderImpl> missionProfileList) {
            this.missionProfileList = MissionProfileListCopier.copyFromBuilder(missionProfileList);
        }

        @Override
        public final Builder missionProfileList(Collection<MissionProfileListItem> missionProfileList) {
            this.missionProfileList = MissionProfileListCopier.copy(missionProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missionProfileList(MissionProfileListItem ... missionProfileList) {
            this.missionProfileList(Arrays.asList(missionProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missionProfileList(Consumer<MissionProfileListItem.Builder> ... missionProfileList) {
            this.missionProfileList(Stream.of(missionProfileList).map(c -> (MissionProfileListItem)((MissionProfileListItem.Builder)MissionProfileListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMissionProfilesResponse build() {
            return new ListMissionProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMissionProfilesResponse> {
        public Builder missionProfileList(Collection<MissionProfileListItem> var1);

        public Builder missionProfileList(MissionProfileListItem ... var1);

        public Builder missionProfileList(Consumer<MissionProfileListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

