/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.EphemerisSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EphemerisMetaData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EphemerisMetaData> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisId").getter(EphemerisMetaData.getter(EphemerisMetaData::ephemerisId)).setter(EphemerisMetaData.setter(Builder::ephemerisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()}).build();
    private static final SdkField<Instant> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("epoch").getter(EphemerisMetaData.getter(EphemerisMetaData::epoch)).setter(EphemerisMetaData.setter(Builder::epoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EphemerisMetaData.getter(EphemerisMetaData::name)).setter(EphemerisMetaData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(EphemerisMetaData.getter(EphemerisMetaData::sourceAsString)).setter(EphemerisMetaData.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD, EPOCH_FIELD, NAME_FIELD, SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ephemerisId;
    private final Instant epoch;
    private final String name;
    private final String source;

    private EphemerisMetaData(BuilderImpl builder) {
        this.ephemerisId = builder.ephemerisId;
        this.epoch = builder.epoch;
        this.name = builder.name;
        this.source = builder.source;
    }

    public final String ephemerisId() {
        return this.ephemerisId;
    }

    public final Instant epoch() {
        return this.epoch;
    }

    public final String name() {
        return this.name;
    }

    public final EphemerisSource source() {
        return EphemerisSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisMetaData)) {
            return false;
        }
        EphemerisMetaData other = (EphemerisMetaData)obj;
        return Objects.equals(this.ephemerisId(), other.ephemerisId()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceAsString(), other.sourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EphemerisMetaData").add("EphemerisId", (Object)this.ephemerisId()).add("Epoch", (Object)this.epoch()).add("Name", (Object)this.name()).add("Source", (Object)this.sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ephemerisId": {
                return Optional.ofNullable(clazz.cast(this.ephemerisId()));
            }
            case "epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisMetaData, T> g) {
        return obj -> g.apply((EphemerisMetaData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ephemerisId;
        private Instant epoch;
        private String name;
        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisMetaData model) {
            this.ephemerisId(model.ephemerisId);
            this.epoch(model.epoch);
            this.name(model.name);
            this.source(model.source);
        }

        public final String getEphemerisId() {
            return this.ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final Instant getEpoch() {
            return this.epoch;
        }

        public final void setEpoch(Instant epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(Instant epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(EphemerisSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public EphemerisMetaData build() {
            return new EphemerisMetaData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EphemerisMetaData> {
        public Builder ephemerisId(String var1);

        public Builder epoch(Instant var1);

        public Builder name(String var1);

        public Builder source(String var1);

        public Builder source(EphemerisSource var1);
    }
}

