/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupCertificateAuthorityRequest extends GreengrassRequest implements
        ToCopyableBuilder<GetGroupCertificateAuthorityRequest.Builder, GetGroupCertificateAuthorityRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityId").getter(getter(GetGroupCertificateAuthorityRequest::certificateAuthorityId))
            .setter(setter(Builder::certificateAuthorityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CertificateAuthorityId").build())
            .build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(GetGroupCertificateAuthorityRequest::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ID_FIELD, GROUP_ID_FIELD));

    private final String certificateAuthorityId;

    private final String groupId;

    private GetGroupCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityId = builder.certificateAuthorityId;
        this.groupId = builder.groupId;
    }

    /**
     * The ID of the certificate authority.
     * 
     * @return The ID of the certificate authority.
     */
    public final String certificateAuthorityId() {
        return certificateAuthorityId;
    }

    /**
     * The ID of the Greengrass group.
     * 
     * @return The ID of the Greengrass group.
     */
    public final String groupId() {
        return groupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupCertificateAuthorityRequest)) {
            return false;
        }
        GetGroupCertificateAuthorityRequest other = (GetGroupCertificateAuthorityRequest) obj;
        return Objects.equals(certificateAuthorityId(), other.certificateAuthorityId())
                && Objects.equals(groupId(), other.groupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupCertificateAuthorityRequest").add("CertificateAuthorityId", certificateAuthorityId())
                .add("GroupId", groupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityId":
            return Optional.ofNullable(clazz.cast(certificateAuthorityId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((GetGroupCertificateAuthorityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GreengrassRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGroupCertificateAuthorityRequest> {
        /**
         * The ID of the certificate authority.
         * 
         * @param certificateAuthorityId
         *        The ID of the certificate authority.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityId(String certificateAuthorityId);

        /**
         * The ID of the Greengrass group.
         * 
         * @param groupId
         *        The ID of the Greengrass group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GreengrassRequest.BuilderImpl implements Builder {
        private String certificateAuthorityId;

        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupCertificateAuthorityRequest model) {
            super(model);
            certificateAuthorityId(model.certificateAuthorityId);
            groupId(model.groupId);
        }

        public final String getCertificateAuthorityId() {
            return certificateAuthorityId;
        }

        public final void setCertificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
        }

        @Override
        public final Builder certificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGroupCertificateAuthorityRequest build() {
            return new GetGroupCertificateAuthorityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
