/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalOptionsCopier;
import software.amazon.awssdk.services.glue.model.GlueSchema;
import software.amazon.awssdk.services.glue.model.GlueSchemasCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparkConnectorSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparkConnectorSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SparkConnectorSource.getter(SparkConnectorSource::name)).setter(SparkConnectorSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(SparkConnectorSource.getter(SparkConnectorSource::connectionName)).setter(SparkConnectorSource.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorName").getter(SparkConnectorSource.getter(SparkConnectorSource::connectorName)).setter(SparkConnectorSource.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorName").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(SparkConnectorSource.getter(SparkConnectorSource::connectionType)).setter(SparkConnectorSource.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalOptions").getter(SparkConnectorSource.getter(SparkConnectorSource::additionalOptions)).setter(SparkConnectorSource.setter(Builder::additionalOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<GlueSchema>> OUTPUT_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputSchemas").getter(SparkConnectorSource.getter(SparkConnectorSource::outputSchemas)).setter(SparkConnectorSource.setter(Builder::outputSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSchemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlueSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONNECTION_NAME_FIELD, CONNECTOR_NAME_FIELD, CONNECTION_TYPE_FIELD, ADDITIONAL_OPTIONS_FIELD, OUTPUT_SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparkConnectorSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String connectionName;
    private final String connectorName;
    private final String connectionType;
    private final Map<String, String> additionalOptions;
    private final List<GlueSchema> outputSchemas;

    private SparkConnectorSource(BuilderImpl builder) {
        this.name = builder.name;
        this.connectionName = builder.connectionName;
        this.connectorName = builder.connectorName;
        this.connectionType = builder.connectionType;
        this.additionalOptions = builder.additionalOptions;
        this.outputSchemas = builder.outputSchemas;
    }

    public final String name() {
        return this.name;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final String connectionType() {
        return this.connectionType;
    }

    public final boolean hasAdditionalOptions() {
        return this.additionalOptions != null && !(this.additionalOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalOptions() {
        return this.additionalOptions;
    }

    public final boolean hasOutputSchemas() {
        return this.outputSchemas != null && !(this.outputSchemas instanceof SdkAutoConstructList);
    }

    public final List<GlueSchema> outputSchemas() {
        return this.outputSchemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalOptions() ? this.additionalOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSchemas() ? this.outputSchemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkConnectorSource)) {
            return false;
        }
        SparkConnectorSource other = (SparkConnectorSource)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.connectionType(), other.connectionType()) && this.hasAdditionalOptions() == other.hasAdditionalOptions() && Objects.equals(this.additionalOptions(), other.additionalOptions()) && this.hasOutputSchemas() == other.hasOutputSchemas() && Objects.equals(this.outputSchemas(), other.outputSchemas());
    }

    public final String toString() {
        return ToString.builder((String)"SparkConnectorSource").add("Name", (Object)this.name()).add("ConnectionName", (Object)this.connectionName()).add("ConnectorName", (Object)this.connectorName()).add("ConnectionType", (Object)this.connectionType()).add("AdditionalOptions", this.hasAdditionalOptions() ? this.additionalOptions() : null).add("OutputSchemas", this.hasOutputSchemas() ? this.outputSchemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "ConnectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionType()));
            }
            case "AdditionalOptions": {
                return Optional.ofNullable(clazz.cast(this.additionalOptions()));
            }
            case "OutputSchemas": {
                return Optional.ofNullable(clazz.cast(this.outputSchemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ConnectionName", CONNECTION_NAME_FIELD);
        map.put("ConnectorName", CONNECTOR_NAME_FIELD);
        map.put("ConnectionType", CONNECTION_TYPE_FIELD);
        map.put("AdditionalOptions", ADDITIONAL_OPTIONS_FIELD);
        map.put("OutputSchemas", OUTPUT_SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkConnectorSource, T> g) {
        return obj -> g.apply((SparkConnectorSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String connectionName;
        private String connectorName;
        private String connectionType;
        private Map<String, String> additionalOptions = DefaultSdkAutoConstructMap.getInstance();
        private List<GlueSchema> outputSchemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SparkConnectorSource model) {
            this.name(model.name);
            this.connectionName(model.connectionName);
            this.connectorName(model.connectorName);
            this.connectionType(model.connectionType);
            this.additionalOptions(model.additionalOptions);
            this.outputSchemas(model.outputSchemas);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final Map<String, String> getAdditionalOptions() {
            if (this.additionalOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalOptions;
        }

        public final void setAdditionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
        }

        @Override
        public final Builder additionalOptions(Map<String, String> additionalOptions) {
            this.additionalOptions = AdditionalOptionsCopier.copy(additionalOptions);
            return this;
        }

        public final List<GlueSchema.Builder> getOutputSchemas() {
            List<GlueSchema.Builder> result = GlueSchemasCopier.copyToBuilder(this.outputSchemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSchemas(Collection<GlueSchema.BuilderImpl> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copyFromBuilder(outputSchemas);
        }

        @Override
        public final Builder outputSchemas(Collection<GlueSchema> outputSchemas) {
            this.outputSchemas = GlueSchemasCopier.copy(outputSchemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(GlueSchema ... outputSchemas) {
            this.outputSchemas(Arrays.asList(outputSchemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSchemas(Consumer<GlueSchema.Builder> ... outputSchemas) {
            this.outputSchemas(Stream.of(outputSchemas).map(c -> (GlueSchema)((GlueSchema.Builder)GlueSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SparkConnectorSource build() {
            return new SparkConnectorSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparkConnectorSource> {
        public Builder name(String var1);

        public Builder connectionName(String var1);

        public Builder connectorName(String var1);

        public Builder connectionType(String var1);

        public Builder additionalOptions(Map<String, String> var1);

        public Builder outputSchemas(Collection<GlueSchema> var1);

        public Builder outputSchemas(GlueSchema ... var1);

        public Builder outputSchemas(Consumer<GlueSchema.Builder> ... var1);
    }
}

