/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DevEndpoint;
import software.amazon.awssdk.services.glue.model.DevEndpointListCopier;
import software.amazon.awssdk.services.glue.model.DevEndpointNamesCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDevEndpointsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetDevEndpointsResponse> {
    private static final SdkField<List<DevEndpoint>> DEV_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevEndpoints").getter(BatchGetDevEndpointsResponse.getter(BatchGetDevEndpointsResponse::devEndpoints)).setter(BatchGetDevEndpointsResponse.setter(Builder::devEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DevEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEV_ENDPOINTS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevEndpointsNotFound").getter(BatchGetDevEndpointsResponse.getter(BatchGetDevEndpointsResponse::devEndpointsNotFound)).setter(BatchGetDevEndpointsResponse.setter(Builder::devEndpointsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINTS_FIELD, DEV_ENDPOINTS_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetDevEndpointsResponse.memberNameToFieldInitializer();
    private final List<DevEndpoint> devEndpoints;
    private final List<String> devEndpointsNotFound;

    private BatchGetDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpoints = builder.devEndpoints;
        this.devEndpointsNotFound = builder.devEndpointsNotFound;
    }

    public final boolean hasDevEndpoints() {
        return this.devEndpoints != null && !(this.devEndpoints instanceof SdkAutoConstructList);
    }

    public final List<DevEndpoint> devEndpoints() {
        return this.devEndpoints;
    }

    public final boolean hasDevEndpointsNotFound() {
        return this.devEndpointsNotFound != null && !(this.devEndpointsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> devEndpointsNotFound() {
        return this.devEndpointsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevEndpoints() ? this.devEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevEndpointsNotFound() ? this.devEndpointsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevEndpointsResponse)) {
            return false;
        }
        BatchGetDevEndpointsResponse other = (BatchGetDevEndpointsResponse)((Object)obj);
        return this.hasDevEndpoints() == other.hasDevEndpoints() && Objects.equals(this.devEndpoints(), other.devEndpoints()) && this.hasDevEndpointsNotFound() == other.hasDevEndpointsNotFound() && Objects.equals(this.devEndpointsNotFound(), other.devEndpointsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDevEndpointsResponse").add("DevEndpoints", this.hasDevEndpoints() ? this.devEndpoints() : null).add("DevEndpointsNotFound", this.hasDevEndpointsNotFound() ? this.devEndpointsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEndpoints": {
                return Optional.ofNullable(clazz.cast(this.devEndpoints()));
            }
            case "DevEndpointsNotFound": {
                return Optional.ofNullable(clazz.cast(this.devEndpointsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DevEndpoints", DEV_ENDPOINTS_FIELD);
        map.put("DevEndpointsNotFound", DEV_ENDPOINTS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevEndpointsResponse, T> g) {
        return obj -> g.apply((BatchGetDevEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DevEndpoint> devEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> devEndpointsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevEndpointsResponse model) {
            super(model);
            this.devEndpoints(model.devEndpoints);
            this.devEndpointsNotFound(model.devEndpointsNotFound);
        }

        public final List<DevEndpoint.Builder> getDevEndpoints() {
            List<DevEndpoint.Builder> result = DevEndpointListCopier.copyToBuilder(this.devEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDevEndpoints(Collection<DevEndpoint.BuilderImpl> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copyFromBuilder(devEndpoints);
        }

        @Override
        public final Builder devEndpoints(Collection<DevEndpoint> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copy(devEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(DevEndpoint ... devEndpoints) {
            this.devEndpoints(Arrays.asList(devEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(Consumer<DevEndpoint.Builder> ... devEndpoints) {
            this.devEndpoints(Stream.of(devEndpoints).map(c -> (DevEndpoint)((DevEndpoint.Builder)DevEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDevEndpointsNotFound() {
            if (this.devEndpointsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devEndpointsNotFound;
        }

        public final void setDevEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
        }

        @Override
        public final Builder devEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointsNotFound(String ... devEndpointsNotFound) {
            this.devEndpointsNotFound(Arrays.asList(devEndpointsNotFound));
            return this;
        }

        @Override
        public BatchGetDevEndpointsResponse build() {
            return new BatchGetDevEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDevEndpointsResponse> {
        public Builder devEndpoints(Collection<DevEndpoint> var1);

        public Builder devEndpoints(DevEndpoint ... var1);

        public Builder devEndpoints(Consumer<DevEndpoint.Builder> ... var1);

        public Builder devEndpointsNotFound(Collection<String> var1);

        public Builder devEndpointsNotFound(String ... var1);
    }
}

