/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NullCheckBoxList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NullCheckBoxList> {
    private static final SdkField<Boolean> IS_EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEmpty").getter(NullCheckBoxList.getter(NullCheckBoxList::isEmpty)).setter(NullCheckBoxList.setter(Builder::isEmpty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEmpty").build()}).build();
    private static final SdkField<Boolean> IS_NULL_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsNullString").getter(NullCheckBoxList.getter(NullCheckBoxList::isNullString)).setter(NullCheckBoxList.setter(Builder::isNullString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNullString").build()}).build();
    private static final SdkField<Boolean> IS_NEG_ONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsNegOne").getter(NullCheckBoxList.getter(NullCheckBoxList::isNegOne)).setter(NullCheckBoxList.setter(Builder::isNegOne)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNegOne").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_EMPTY_FIELD, IS_NULL_STRING_FIELD, IS_NEG_ONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NullCheckBoxList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isEmpty;
    private final Boolean isNullString;
    private final Boolean isNegOne;

    private NullCheckBoxList(BuilderImpl builder) {
        this.isEmpty = builder.isEmpty;
        this.isNullString = builder.isNullString;
        this.isNegOne = builder.isNegOne;
    }

    public final Boolean isEmpty() {
        return this.isEmpty;
    }

    public final Boolean isNullString() {
        return this.isNullString;
    }

    public final Boolean isNegOne() {
        return this.isNegOne;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isEmpty());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNullString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNegOne());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NullCheckBoxList)) {
            return false;
        }
        NullCheckBoxList other = (NullCheckBoxList)obj;
        return Objects.equals(this.isEmpty(), other.isEmpty()) && Objects.equals(this.isNullString(), other.isNullString()) && Objects.equals(this.isNegOne(), other.isNegOne());
    }

    public final String toString() {
        return ToString.builder((String)"NullCheckBoxList").add("IsEmpty", (Object)this.isEmpty()).add("IsNullString", (Object)this.isNullString()).add("IsNegOne", (Object)this.isNegOne()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsEmpty": {
                return Optional.ofNullable(clazz.cast(this.isEmpty()));
            }
            case "IsNullString": {
                return Optional.ofNullable(clazz.cast(this.isNullString()));
            }
            case "IsNegOne": {
                return Optional.ofNullable(clazz.cast(this.isNegOne()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Boolean>> map = new HashMap<String, SdkField<Boolean>>();
        map.put("IsEmpty", IS_EMPTY_FIELD);
        map.put("IsNullString", IS_NULL_STRING_FIELD);
        map.put("IsNegOne", IS_NEG_ONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NullCheckBoxList, T> g) {
        return obj -> g.apply((NullCheckBoxList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isEmpty;
        private Boolean isNullString;
        private Boolean isNegOne;

        private BuilderImpl() {
        }

        private BuilderImpl(NullCheckBoxList model) {
            this.isEmpty(model.isEmpty);
            this.isNullString(model.isNullString);
            this.isNegOne(model.isNegOne);
        }

        public final Boolean getIsEmpty() {
            return this.isEmpty;
        }

        public final void setIsEmpty(Boolean isEmpty) {
            this.isEmpty = isEmpty;
        }

        @Override
        public final Builder isEmpty(Boolean isEmpty) {
            this.isEmpty = isEmpty;
            return this;
        }

        public final Boolean getIsNullString() {
            return this.isNullString;
        }

        public final void setIsNullString(Boolean isNullString) {
            this.isNullString = isNullString;
        }

        @Override
        public final Builder isNullString(Boolean isNullString) {
            this.isNullString = isNullString;
            return this;
        }

        public final Boolean getIsNegOne() {
            return this.isNegOne;
        }

        public final void setIsNegOne(Boolean isNegOne) {
            this.isNegOne = isNegOne;
        }

        @Override
        public final Builder isNegOne(Boolean isNegOne) {
            this.isNegOne = isNegOne;
            return this;
        }

        public NullCheckBoxList build() {
            return new NullCheckBoxList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NullCheckBoxList> {
        public Builder isEmpty(Boolean var1);

        public Builder isNullString(Boolean var1);

        public Builder isNegOne(Boolean var1);
    }
}

