/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error record for table operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableError implements SdkPojo, Serializable, ToCopyableBuilder<TableError.Builder, TableError> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TableError::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetail").getter(getter(TableError::errorDetail)).setter(setter(Builder::errorDetail))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            ERROR_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final ErrorDetail errorDetail;

    private TableError(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * <p>
     * The name of the table. For Hive compatibility, this must be entirely lowercase.
     * </p>
     * 
     * @return The name of the table. For Hive compatibility, this must be entirely lowercase.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The details about the error.
     * </p>
     * 
     * @return The details about the error.
     */
    public final ErrorDetail errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableError)) {
            return false;
        }
        TableError other = (TableError) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableError").add("TableName", tableName()).add("ErrorDetail", errorDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableError, T> g) {
        return obj -> g.apply((TableError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableError> {
        /**
         * <p>
         * The name of the table. For Hive compatibility, this must be entirely lowercase.
         * </p>
         * 
         * @param tableName
         *        The name of the table. For Hive compatibility, this must be entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The details about the error.
         * </p>
         * 
         * @param errorDetail
         *        The details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(ErrorDetail errorDetail);

        /**
         * <p>
         * The details about the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #errorDetail(ErrorDetail)}.
         * 
         * @param errorDetail
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetail(ErrorDetail)
         */
        default Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return errorDetail(ErrorDetail.builder().applyMutation(errorDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(TableError model) {
            tableName(model.tableName);
            errorDetail(model.errorDetail);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return errorDetail != null ? errorDetail.toBuilder() : null;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        @Override
        public TableError build() {
            return new TableError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
