/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTriggerRequest extends GlueRequest implements
        ToCopyableBuilder<CreateTriggerRequest.Builder, CreateTriggerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateTriggerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowName").getter(getter(CreateTriggerRequest::workflowName)).setter(setter(Builder::workflowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateTriggerRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateTriggerRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.<Predicate> builder(MarshallingType.SDK_POJO)
            .memberName("Predicate").getter(getter(CreateTriggerRequest::predicate)).setter(setter(Builder::predicate))
            .constructor(Predicate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()).build();

    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(CreateTriggerRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateTriggerRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> START_ON_CREATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StartOnCreation").getter(getter(CreateTriggerRequest::startOnCreation))
            .setter(setter(Builder::startOnCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartOnCreation").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateTriggerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<EventBatchingCondition> EVENT_BATCHING_CONDITION_FIELD = SdkField
            .<EventBatchingCondition> builder(MarshallingType.SDK_POJO).memberName("EventBatchingCondition")
            .getter(getter(CreateTriggerRequest::eventBatchingCondition)).setter(setter(Builder::eventBatchingCondition))
            .constructor(EventBatchingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBatchingCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            WORKFLOW_NAME_FIELD, TYPE_FIELD, SCHEDULE_FIELD, PREDICATE_FIELD, ACTIONS_FIELD, DESCRIPTION_FIELD,
            START_ON_CREATION_FIELD, TAGS_FIELD, EVENT_BATCHING_CONDITION_FIELD));

    private final String name;

    private final String workflowName;

    private final String type;

    private final String schedule;

    private final Predicate predicate;

    private final List<Action> actions;

    private final String description;

    private final Boolean startOnCreation;

    private final Map<String, String> tags;

    private final EventBatchingCondition eventBatchingCondition;

    private CreateTriggerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.workflowName = builder.workflowName;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.predicate = builder.predicate;
        this.actions = builder.actions;
        this.description = builder.description;
        this.startOnCreation = builder.startOnCreation;
        this.tags = builder.tags;
        this.eventBatchingCondition = builder.eventBatchingCondition;
    }

    /**
     * <p>
     * The name of the trigger.
     * </p>
     * 
     * @return The name of the trigger.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the workflow associated with the trigger.
     * </p>
     * 
     * @return The name of the workflow associated with the trigger.
     */
    public final String workflowName() {
        return workflowName;
    }

    /**
     * <p>
     * The type of the new trigger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the new trigger.
     * @see TriggerType
     */
    public final TriggerType type() {
        return TriggerType.fromValue(type);
    }

    /**
     * <p>
     * The type of the new trigger.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TriggerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the new trigger.
     * @see TriggerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>cron</code> expression used to specify the schedule (see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for
     * Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
     * <code>cron(15 12 * * ? *)</code>.
     * </p>
     * <p>
     * This field is required when the trigger type is SCHEDULED.
     * </p>
     * 
     * @return A <code>cron</code> expression used to specify the schedule (see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
     *         Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
     *         specify: <code>cron(15 12 * * ? *)</code>.</p>
     *         <p>
     *         This field is required when the trigger type is SCHEDULED.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * A predicate to specify when the new trigger should fire.
     * </p>
     * <p>
     * This field is required when the trigger type is <code>CONDITIONAL</code>.
     * </p>
     * 
     * @return A predicate to specify when the new trigger should fire.</p>
     *         <p>
     *         This field is required when the trigger type is <code>CONDITIONAL</code>.
     */
    public final Predicate predicate() {
        return predicate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions initiated by this trigger when it fires.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions initiated by this trigger when it fires.
     */
    public final List<Action> actions() {
        return actions;
    }

    /**
     * <p>
     * A description of the new trigger.
     * </p>
     * 
     * @return A description of the new trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code> triggers when created. True
     * is not supported for <code>ON_DEMAND</code> triggers.
     * </p>
     * 
     * @return Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code> triggers when
     *         created. True is not supported for <code>ON_DEMAND</code> triggers.
     */
    public final Boolean startOnCreation() {
        return startOnCreation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to use with this trigger. You may use tags to limit access to the trigger. For more information about
     * tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags
     * in Glue</a> in the developer guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to use with this trigger. You may use tags to limit access to the trigger. For more information
     *         about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web
     *         Services Tags in Glue</a> in the developer guide.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Batch condition that must be met (specified number of events received or batch time window expired) before
     * EventBridge event trigger fires.
     * </p>
     * 
     * @return Batch condition that must be met (specified number of events received or batch time window expired)
     *         before EventBridge event trigger fires.
     */
    public final EventBatchingCondition eventBatchingCondition() {
        return eventBatchingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(predicate());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventBatchingCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTriggerRequest)) {
            return false;
        }
        CreateTriggerRequest other = (CreateTriggerRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(workflowName(), other.workflowName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(predicate(), other.predicate()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && Objects.equals(description(), other.description())
                && Objects.equals(startOnCreation(), other.startOnCreation()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(eventBatchingCondition(), other.eventBatchingCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTriggerRequest").add("Name", name()).add("WorkflowName", workflowName())
                .add("Type", typeAsString()).add("Schedule", schedule()).add("Predicate", predicate())
                .add("Actions", hasActions() ? actions() : null).add("Description", description())
                .add("StartOnCreation", startOnCreation()).add("Tags", hasTags() ? tags() : null)
                .add("EventBatchingCondition", eventBatchingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "WorkflowName":
            return Optional.ofNullable(clazz.cast(workflowName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "Predicate":
            return Optional.ofNullable(clazz.cast(predicate()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartOnCreation":
            return Optional.ofNullable(clazz.cast(startOnCreation()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EventBatchingCondition":
            return Optional.ofNullable(clazz.cast(eventBatchingCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTriggerRequest, T> g) {
        return obj -> g.apply((CreateTriggerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTriggerRequest> {
        /**
         * <p>
         * The name of the trigger.
         * </p>
         * 
         * @param name
         *        The name of the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the workflow associated with the trigger.
         * </p>
         * 
         * @param workflowName
         *        The name of the workflow associated with the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowName(String workflowName);

        /**
         * <p>
         * The type of the new trigger.
         * </p>
         * 
         * @param type
         *        The type of the new trigger.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the new trigger.
         * </p>
         * 
         * @param type
         *        The type of the new trigger.
         * @see TriggerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TriggerType
         */
        Builder type(TriggerType type);

        /**
         * <p>
         * A <code>cron</code> expression used to specify the schedule (see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules
         * for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
         * <code>cron(15 12 * * ? *)</code>.
         * </p>
         * <p>
         * This field is required when the trigger type is SCHEDULED.
         * </p>
         * 
         * @param schedule
         *        A <code>cron</code> expression used to specify the schedule (see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
         *        Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
         *        specify: <code>cron(15 12 * * ? *)</code>.</p>
         *        <p>
         *        This field is required when the trigger type is SCHEDULED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * A predicate to specify when the new trigger should fire.
         * </p>
         * <p>
         * This field is required when the trigger type is <code>CONDITIONAL</code>.
         * </p>
         * 
         * @param predicate
         *        A predicate to specify when the new trigger should fire.</p>
         *        <p>
         *        This field is required when the trigger type is <code>CONDITIONAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicate(Predicate predicate);

        /**
         * <p>
         * A predicate to specify when the new trigger should fire.
         * </p>
         * <p>
         * This field is required when the trigger type is <code>CONDITIONAL</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Predicate.Builder} avoiding the need to
         * create one manually via {@link Predicate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Predicate.Builder#build()} is called immediately and its result
         * is passed to {@link #predicate(Predicate)}.
         * 
         * @param predicate
         *        a consumer that will call methods on {@link Predicate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predicate(Predicate)
         */
        default Builder predicate(Consumer<Predicate.Builder> predicate) {
            return predicate(Predicate.builder().applyMutation(predicate).build());
        }

        /**
         * <p>
         * The actions initiated by this trigger when it fires.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger when it fires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<Action> actions);

        /**
         * <p>
         * The actions initiated by this trigger when it fires.
         * </p>
         * 
         * @param actions
         *        The actions initiated by this trigger when it fires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Action... actions);

        /**
         * <p>
         * The actions initiated by this trigger when it fires.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Action.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Action.Builder#build()} is called immediately and its
         * result is passed to {@link #actions(List<Action>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.glue.model.Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<Action>)
         */
        Builder actions(Consumer<Action.Builder>... actions);

        /**
         * <p>
         * A description of the new trigger.
         * </p>
         * 
         * @param description
         *        A description of the new trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code> triggers when created.
         * True is not supported for <code>ON_DEMAND</code> triggers.
         * </p>
         * 
         * @param startOnCreation
         *        Set to <code>true</code> to start <code>SCHEDULED</code> and <code>CONDITIONAL</code> triggers when
         *        created. True is not supported for <code>ON_DEMAND</code> triggers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startOnCreation(Boolean startOnCreation);

        /**
         * <p>
         * The tags to use with this trigger. You may use tags to limit access to the trigger. For more information
         * about tags in Glue, see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web
         * Services Tags in Glue</a> in the developer guide.
         * </p>
         * 
         * @param tags
         *        The tags to use with this trigger. You may use tags to limit access to the trigger. For more
         *        information about tags in Glue, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html">Amazon Web Services Tags in
         *        Glue</a> in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Batch condition that must be met (specified number of events received or batch time window expired) before
         * EventBridge event trigger fires.
         * </p>
         * 
         * @param eventBatchingCondition
         *        Batch condition that must be met (specified number of events received or batch time window expired)
         *        before EventBridge event trigger fires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition);

        /**
         * <p>
         * Batch condition that must be met (specified number of events received or batch time window expired) before
         * EventBridge event trigger fires.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBatchingCondition.Builder} avoiding
         * the need to create one manually via {@link EventBatchingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBatchingCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #eventBatchingCondition(EventBatchingCondition)}.
         * 
         * @param eventBatchingCondition
         *        a consumer that will call methods on {@link EventBatchingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBatchingCondition(EventBatchingCondition)
         */
        default Builder eventBatchingCondition(Consumer<EventBatchingCondition.Builder> eventBatchingCondition) {
            return eventBatchingCondition(EventBatchingCondition.builder().applyMutation(eventBatchingCondition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String name;

        private String workflowName;

        private String type;

        private String schedule;

        private Predicate predicate;

        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean startOnCreation;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private EventBatchingCondition eventBatchingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTriggerRequest model) {
            super(model);
            name(model.name);
            workflowName(model.workflowName);
            type(model.type);
            schedule(model.schedule);
            predicate(model.predicate);
            actions(model.actions);
            description(model.description);
            startOnCreation(model.startOnCreation);
            tags(model.tags);
            eventBatchingCondition(model.eventBatchingCondition);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkflowName() {
            return workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TriggerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return predicate != null ? predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder>... actions) {
            actions(Stream.of(actions).map(c -> Action.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getStartOnCreation() {
            return startOnCreation;
        }

        public final void setStartOnCreation(Boolean startOnCreation) {
            this.startOnCreation = startOnCreation;
        }

        @Override
        public final Builder startOnCreation(Boolean startOnCreation) {
            this.startOnCreation = startOnCreation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final EventBatchingCondition.Builder getEventBatchingCondition() {
            return eventBatchingCondition != null ? eventBatchingCondition.toBuilder() : null;
        }

        public final void setEventBatchingCondition(EventBatchingCondition.BuilderImpl eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition != null ? eventBatchingCondition.build() : null;
        }

        @Override
        public final Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTriggerRequest build() {
            return new CreateTriggerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
