/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterOperation {
    EQ("EQ"),
    LT("LT"),
    GT("GT"),
    LTE("LTE"),
    GTE("GTE"),
    REGEX("REGEX"),
    ISNULL("ISNULL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterOperation> VALUE_MAP;
    private final String value;

    private FilterOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterOperation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterOperation> knownValues() {
        EnumSet<FilterOperation> knownValues = EnumSet.allOf(FilterOperation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterOperation.class, FilterOperation::toString);
    }
}

