/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;

public class ListCustomRoutingListenersPublisher
implements SdkPublisher<ListCustomRoutingListenersResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCustomRoutingListenersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomRoutingListenersPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingListenersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomRoutingListenersPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingListenersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomRoutingListenersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomRoutingListenersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomRoutingListener> listeners() {
        Function<ListCustomRoutingListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.listeners() != null) {
                return response.listeners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomRoutingListenersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomRoutingListenersResponseFetcher
    implements AsyncPageFetcher<ListCustomRoutingListenersResponse> {
        private ListCustomRoutingListenersResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomRoutingListenersResponse> nextPage(ListCustomRoutingListenersResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingListenersPublisher.this.client.listCustomRoutingListeners(ListCustomRoutingListenersPublisher.this.firstRequest);
            }
            return ListCustomRoutingListenersPublisher.this.client.listCustomRoutingListeners((ListCustomRoutingListenersRequest)((Object)ListCustomRoutingListenersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

