/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAcceleratorAttributesResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<DescribeAcceleratorAttributesResponse.Builder, DescribeAcceleratorAttributesResponse> {
    private static final SdkField<AcceleratorAttributes> ACCELERATOR_ATTRIBUTES_FIELD = SdkField
            .<AcceleratorAttributes> builder(MarshallingType.SDK_POJO).memberName("AcceleratorAttributes")
            .getter(getter(DescribeAcceleratorAttributesResponse::acceleratorAttributes))
            .setter(setter(Builder::acceleratorAttributes)).constructor(AcceleratorAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ATTRIBUTES_FIELD));

    private final AcceleratorAttributes acceleratorAttributes;

    private DescribeAcceleratorAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.acceleratorAttributes = builder.acceleratorAttributes;
    }

    /**
     * <p>
     * The attributes of the accelerator.
     * </p>
     * 
     * @return The attributes of the accelerator.
     */
    public final AcceleratorAttributes acceleratorAttributes() {
        return acceleratorAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcceleratorAttributesResponse)) {
            return false;
        }
        DescribeAcceleratorAttributesResponse other = (DescribeAcceleratorAttributesResponse) obj;
        return Objects.equals(acceleratorAttributes(), other.acceleratorAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAcceleratorAttributesResponse").add("AcceleratorAttributes", acceleratorAttributes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorAttributes":
            return Optional.ofNullable(clazz.cast(acceleratorAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcceleratorAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAcceleratorAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAcceleratorAttributesResponse> {
        /**
         * <p>
         * The attributes of the accelerator.
         * </p>
         * 
         * @param acceleratorAttributes
         *        The attributes of the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorAttributes(AcceleratorAttributes acceleratorAttributes);

        /**
         * <p>
         * The attributes of the accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceleratorAttributes.Builder} avoiding
         * the need to create one manually via {@link AcceleratorAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceleratorAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #acceleratorAttributes(AcceleratorAttributes)}.
         * 
         * @param acceleratorAttributes
         *        a consumer that will call methods on {@link AcceleratorAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorAttributes(AcceleratorAttributes)
         */
        default Builder acceleratorAttributes(Consumer<AcceleratorAttributes.Builder> acceleratorAttributes) {
            return acceleratorAttributes(AcceleratorAttributes.builder().applyMutation(acceleratorAttributes).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private AcceleratorAttributes acceleratorAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcceleratorAttributesResponse model) {
            super(model);
            acceleratorAttributes(model.acceleratorAttributes);
        }

        public final AcceleratorAttributes.Builder getAcceleratorAttributes() {
            return acceleratorAttributes != null ? acceleratorAttributes.toBuilder() : null;
        }

        public final void setAcceleratorAttributes(AcceleratorAttributes.BuilderImpl acceleratorAttributes) {
            this.acceleratorAttributes = acceleratorAttributes != null ? acceleratorAttributes.build() : null;
        }

        @Override
        public final Builder acceleratorAttributes(AcceleratorAttributes acceleratorAttributes) {
            this.acceleratorAttributes = acceleratorAttributes;
            return this;
        }

        @Override
        public DescribeAcceleratorAttributesResponse build() {
            return new DescribeAcceleratorAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
