/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointIdentifier> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(EndpointIdentifier.getter(EndpointIdentifier::endpointId)).setter(EndpointIdentifier.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<Boolean> CLIENT_IP_PRESERVATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClientIPPreservationEnabled").getter(EndpointIdentifier.getter(EndpointIdentifier::clientIPPreservationEnabled)).setter(EndpointIdentifier.setter(Builder::clientIPPreservationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIPPreservationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, CLIENT_IP_PRESERVATION_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointId;
    private final Boolean clientIPPreservationEnabled;

    private EndpointIdentifier(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.clientIPPreservationEnabled = builder.clientIPPreservationEnabled;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final Boolean clientIPPreservationEnabled() {
        return this.clientIPPreservationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIPPreservationEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointIdentifier)) {
            return false;
        }
        EndpointIdentifier other = (EndpointIdentifier)obj;
        return Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.clientIPPreservationEnabled(), other.clientIPPreservationEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointIdentifier").add("EndpointId", (Object)this.endpointId()).add("ClientIPPreservationEnabled", (Object)this.clientIPPreservationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "ClientIPPreservationEnabled": {
                return Optional.ofNullable(clazz.cast(this.clientIPPreservationEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointIdentifier, T> g) {
        return obj -> g.apply((EndpointIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointId;
        private Boolean clientIPPreservationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointIdentifier model) {
            this.endpointId(model.endpointId);
            this.clientIPPreservationEnabled(model.clientIPPreservationEnabled);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Boolean getClientIPPreservationEnabled() {
            return this.clientIPPreservationEnabled;
        }

        public final void setClientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
        }

        @Override
        public final Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
            return this;
        }

        public EndpointIdentifier build() {
            return new EndpointIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointIdentifier> {
        public Builder endpointId(String var1);

        public Builder clientIPPreservationEnabled(Boolean var1);
    }
}

