/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.Listener;

public class ListListenersIterable
implements SdkIterable<ListListenersResponse> {
    private final GlobalAcceleratorClient client;
    private final ListListenersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListListenersIterable(GlobalAcceleratorClient client, ListListenersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListListenersResponseFetcher();
    }

    public Iterator<ListListenersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Listener> listeners() {
        Function<ListListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.listeners() != null) {
                return response.listeners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListListenersResponseFetcher
    implements SyncPageFetcher<ListListenersResponse> {
        private ListListenersResponseFetcher() {
        }

        public boolean hasNextPage(ListListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListListenersResponse nextPage(ListListenersResponse previousPage) {
            if (previousPage == null) {
                return ListListenersIterable.this.client.listListeners(ListListenersIterable.this.firstRequest);
            }
            return ListListenersIterable.this.client.listListeners((ListListenersRequest)((Object)ListListenersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

