/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationAddressesCopier;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationPortsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DenyCustomRoutingTrafficRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, DenyCustomRoutingTrafficRequest> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(DenyCustomRoutingTrafficRequest.getter(DenyCustomRoutingTrafficRequest::endpointGroupArn)).setter(DenyCustomRoutingTrafficRequest.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(DenyCustomRoutingTrafficRequest.getter(DenyCustomRoutingTrafficRequest::endpointId)).setter(DenyCustomRoutingTrafficRequest.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationAddresses").getter(DenyCustomRoutingTrafficRequest.getter(DenyCustomRoutingTrafficRequest::destinationAddresses)).setter(DenyCustomRoutingTrafficRequest.setter(Builder::destinationAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> DESTINATION_PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPorts").getter(DenyCustomRoutingTrafficRequest.getter(DenyCustomRoutingTrafficRequest::destinationPorts)).setter(DenyCustomRoutingTrafficRequest.setter(Builder::destinationPorts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPorts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DENY_ALL_TRAFFIC_TO_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DenyAllTrafficToEndpoint").getter(DenyCustomRoutingTrafficRequest.getter(DenyCustomRoutingTrafficRequest::denyAllTrafficToEndpoint)).setter(DenyCustomRoutingTrafficRequest.setter(Builder::denyAllTrafficToEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DenyAllTrafficToEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_ID_FIELD, DESTINATION_ADDRESSES_FIELD, DESTINATION_PORTS_FIELD, DENY_ALL_TRAFFIC_TO_ENDPOINT_FIELD));
    private final String endpointGroupArn;
    private final String endpointId;
    private final List<String> destinationAddresses;
    private final List<Integer> destinationPorts;
    private final Boolean denyAllTrafficToEndpoint;

    private DenyCustomRoutingTrafficRequest(BuilderImpl builder) {
        super(builder);
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.destinationAddresses = builder.destinationAddresses;
        this.destinationPorts = builder.destinationPorts;
        this.denyAllTrafficToEndpoint = builder.denyAllTrafficToEndpoint;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final boolean hasDestinationAddresses() {
        return this.destinationAddresses != null && !(this.destinationAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public final boolean hasDestinationPorts() {
        return this.destinationPorts != null && !(this.destinationPorts instanceof SdkAutoConstructList);
    }

    public final List<Integer> destinationPorts() {
        return this.destinationPorts;
    }

    public final Boolean denyAllTrafficToEndpoint() {
        return this.denyAllTrafficToEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationAddresses() ? this.destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPorts() ? this.destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.denyAllTrafficToEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DenyCustomRoutingTrafficRequest)) {
            return false;
        }
        DenyCustomRoutingTrafficRequest other = (DenyCustomRoutingTrafficRequest)((Object)obj);
        return Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointId(), other.endpointId()) && this.hasDestinationAddresses() == other.hasDestinationAddresses() && Objects.equals(this.destinationAddresses(), other.destinationAddresses()) && this.hasDestinationPorts() == other.hasDestinationPorts() && Objects.equals(this.destinationPorts(), other.destinationPorts()) && Objects.equals(this.denyAllTrafficToEndpoint(), other.denyAllTrafficToEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"DenyCustomRoutingTrafficRequest").add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointId", (Object)this.endpointId()).add("DestinationAddresses", this.hasDestinationAddresses() ? this.destinationAddresses() : null).add("DestinationPorts", this.hasDestinationPorts() ? this.destinationPorts() : null).add("DenyAllTrafficToEndpoint", (Object)this.denyAllTrafficToEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "DestinationAddresses": {
                return Optional.ofNullable(clazz.cast(this.destinationAddresses()));
            }
            case "DestinationPorts": {
                return Optional.ofNullable(clazz.cast(this.destinationPorts()));
            }
            case "DenyAllTrafficToEndpoint": {
                return Optional.ofNullable(clazz.cast(this.denyAllTrafficToEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DenyCustomRoutingTrafficRequest, T> g) {
        return obj -> g.apply((DenyCustomRoutingTrafficRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String endpointGroupArn;
        private String endpointId;
        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> destinationPorts = DefaultSdkAutoConstructList.getInstance();
        private Boolean denyAllTrafficToEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DenyCustomRoutingTrafficRequest model) {
            super(model);
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointId(model.endpointId);
            this.destinationAddresses(model.destinationAddresses);
            this.destinationPorts(model.destinationPorts);
            this.denyAllTrafficToEndpoint(model.denyAllTrafficToEndpoint);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Collection<String> getDestinationAddresses() {
            if (this.destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationAddresses;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String ... destinationAddresses) {
            this.destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final Collection<Integer> getDestinationPorts() {
            if (this.destinationPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPorts;
        }

        public final void setDestinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Integer ... destinationPorts) {
            this.destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        public final Boolean getDenyAllTrafficToEndpoint() {
            return this.denyAllTrafficToEndpoint;
        }

        public final void setDenyAllTrafficToEndpoint(Boolean denyAllTrafficToEndpoint) {
            this.denyAllTrafficToEndpoint = denyAllTrafficToEndpoint;
        }

        @Override
        public final Builder denyAllTrafficToEndpoint(Boolean denyAllTrafficToEndpoint) {
            this.denyAllTrafficToEndpoint = denyAllTrafficToEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DenyCustomRoutingTrafficRequest build() {
            return new DenyCustomRoutingTrafficRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DenyCustomRoutingTrafficRequest> {
        public Builder endpointGroupArn(String var1);

        public Builder endpointId(String var1);

        public Builder destinationAddresses(Collection<String> var1);

        public Builder destinationAddresses(String ... var1);

        public Builder destinationPorts(Collection<Integer> var1);

        public Builder destinationPorts(Integer ... var1);

        public Builder denyAllTrafficToEndpoint(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

