/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ConflictException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListAcceleratorsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListByoipCidrsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingAcceleratorsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingEndpointGroupsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingListenersIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsByDestinationIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListCustomRoutingPortMappingsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListEndpointGroupsIterable;
import software.amazon.awssdk.services.globalaccelerator.paginators.ListListenersIterable;
import software.amazon.awssdk.services.globalaccelerator.transform.AddCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AllowCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DenyCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsByDestinationRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultGlobalAcceleratorClient
implements GlobalAcceleratorClient {
    private static final Logger log = Logger.loggerFor(DefaultGlobalAcceleratorClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGlobalAcceleratorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "globalaccelerator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddCustomRoutingEndpointsResponse addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) throws EndpointAlreadyExistsException, EndpointGroupNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddCustomRoutingEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, addCustomRoutingEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddCustomRoutingEndpoints");
            AddCustomRoutingEndpointsResponse addCustomRoutingEndpointsResponse = (AddCustomRoutingEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddCustomRoutingEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addCustomRoutingEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddCustomRoutingEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addCustomRoutingEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$addCustomRoutingEndpoints$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AdvertiseByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, advertiseByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AdvertiseByoipCidr");
            AdvertiseByoipCidrResponse advertiseByoipCidrResponse = (AdvertiseByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AdvertiseByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)advertiseByoipCidrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AdvertiseByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return advertiseByoipCidrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$advertiseByoipCidr$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllowCustomRoutingTrafficResponse allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) throws InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllowCustomRoutingTrafficResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, allowCustomRoutingTrafficRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllowCustomRoutingTraffic");
            AllowCustomRoutingTrafficResponse allowCustomRoutingTrafficResponse = (AllowCustomRoutingTrafficResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllowCustomRoutingTraffic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)allowCustomRoutingTrafficRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AllowCustomRoutingTrafficRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return allowCustomRoutingTrafficResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$allowCustomRoutingTraffic$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAcceleratorResponse createAccelerator(CreateAcceleratorRequest createAcceleratorRequest) throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccelerator");
            CreateAcceleratorResponse createAcceleratorResponse = (CreateAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createAccelerator$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomRoutingAcceleratorResponse createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingAccelerator");
            CreateCustomRoutingAcceleratorResponse createCustomRoutingAcceleratorResponse = (CreateCustomRoutingAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomRoutingAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomRoutingAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createCustomRoutingAccelerator$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomRoutingEndpointGroupResponse createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException, InvalidArgumentException, InvalidPortRangeException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingEndpointGroup");
            CreateCustomRoutingEndpointGroupResponse createCustomRoutingEndpointGroupResponse = (CreateCustomRoutingEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomRoutingEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomRoutingEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createCustomRoutingEndpointGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomRoutingListenerResponse createCustomRoutingListener(CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomRoutingListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomRoutingListener");
            CreateCustomRoutingListenerResponse createCustomRoutingListenerResponse = (CreateCustomRoutingListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomRoutingListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomRoutingListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomRoutingListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createCustomRoutingListener$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointGroupResponse createEndpointGroup(CreateEndpointGroupRequest createEndpointGroupRequest) throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpointGroup");
            CreateEndpointGroupResponse createEndpointGroupResponse = (CreateEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createEndpointGroup$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, createListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateListener");
            CreateListenerResponse createListenerResponse = (CreateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$createListener$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAcceleratorResponse deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest) throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccelerator");
            DeleteAcceleratorResponse deleteAcceleratorResponse = (DeleteAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteAccelerator$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomRoutingAcceleratorResponse deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingAccelerator");
            DeleteCustomRoutingAcceleratorResponse deleteCustomRoutingAcceleratorResponse = (DeleteCustomRoutingAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomRoutingAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomRoutingAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteCustomRoutingAccelerator$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomRoutingEndpointGroupResponse deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingEndpointGroup");
            DeleteCustomRoutingEndpointGroupResponse deleteCustomRoutingEndpointGroupResponse = (DeleteCustomRoutingEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomRoutingEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomRoutingEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteCustomRoutingEndpointGroup$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomRoutingListenerResponse deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomRoutingListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomRoutingListener");
            DeleteCustomRoutingListenerResponse deleteCustomRoutingListenerResponse = (DeleteCustomRoutingListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomRoutingListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomRoutingListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomRoutingListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteCustomRoutingListener$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointGroupResponse deleteEndpointGroup(DeleteEndpointGroupRequest deleteEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpointGroup");
            DeleteEndpointGroupResponse deleteEndpointGroupResponse = (DeleteEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteEndpointGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deleteListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteListener");
            DeleteListenerResponse deleteListenerResponse = (DeleteListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deleteListener$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DenyCustomRoutingTrafficResponse denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) throws InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DenyCustomRoutingTrafficResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, denyCustomRoutingTrafficRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DenyCustomRoutingTraffic");
            DenyCustomRoutingTrafficResponse denyCustomRoutingTrafficResponse = (DenyCustomRoutingTrafficResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DenyCustomRoutingTraffic").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)denyCustomRoutingTrafficRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DenyCustomRoutingTrafficRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return denyCustomRoutingTrafficResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$denyCustomRoutingTraffic$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprovisionByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, deprovisionByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprovisionByoipCidr");
            DeprovisionByoipCidrResponse deprovisionByoipCidrResponse = (DeprovisionByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprovisionByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprovisionByoipCidrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeprovisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deprovisionByoipCidrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$deprovisionByoipCidr$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAcceleratorResponse describeAccelerator(DescribeAcceleratorRequest describeAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccelerator");
            DescribeAcceleratorResponse describeAcceleratorResponse = (DescribeAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeAccelerator$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAcceleratorAttributesResponse describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAcceleratorAttributes");
            DescribeAcceleratorAttributesResponse describeAcceleratorAttributesResponse = (DescribeAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAcceleratorAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAcceleratorAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeAcceleratorAttributes$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomRoutingAcceleratorResponse describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingAccelerator");
            DescribeCustomRoutingAcceleratorResponse describeCustomRoutingAcceleratorResponse = (DescribeCustomRoutingAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomRoutingAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomRoutingAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeCustomRoutingAccelerator$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomRoutingAcceleratorAttributesResponse describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingAcceleratorAttributes");
            DescribeCustomRoutingAcceleratorAttributesResponse describeCustomRoutingAcceleratorAttributesResponse = (DescribeCustomRoutingAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomRoutingAcceleratorAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomRoutingAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomRoutingAcceleratorAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeCustomRoutingAcceleratorAttributes$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomRoutingEndpointGroupResponse describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingEndpointGroup");
            DescribeCustomRoutingEndpointGroupResponse describeCustomRoutingEndpointGroupResponse = (DescribeCustomRoutingEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomRoutingEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomRoutingEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomRoutingEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeCustomRoutingEndpointGroup$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCustomRoutingListenerResponse describeCustomRoutingListener(DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCustomRoutingListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCustomRoutingListener");
            DescribeCustomRoutingListenerResponse describeCustomRoutingListenerResponse = (DescribeCustomRoutingListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCustomRoutingListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCustomRoutingListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCustomRoutingListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeCustomRoutingListener$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointGroupResponse describeEndpointGroup(DescribeEndpointGroupRequest describeEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpointGroup");
            DescribeEndpointGroupResponse describeEndpointGroupResponse = (DescribeEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeEndpointGroup$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeListenerResponse describeListener(DescribeListenerRequest describeListenerRequest) throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, describeListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeListener");
            DescribeListenerResponse describeListenerResponse = (DescribeListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$describeListener$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAcceleratorsResponse listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest) throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAcceleratorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listAcceleratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccelerators");
            ListAcceleratorsResponse listAcceleratorsResponse = (ListAcceleratorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccelerators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAcceleratorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAcceleratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAcceleratorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listAccelerators$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAcceleratorsIterable listAcceleratorsPaginator(ListAcceleratorsRequest listAcceleratorsRequest) throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListAcceleratorsIterable(this, this.applyPaginatorUserAgent(listAcceleratorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListByoipCidrsResponse listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListByoipCidrsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listByoipCidrsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListByoipCidrs");
            ListByoipCidrsResponse listByoipCidrsResponse = (ListByoipCidrsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListByoipCidrs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listByoipCidrsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListByoipCidrsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listByoipCidrsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listByoipCidrs$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListByoipCidrsIterable listByoipCidrsPaginator(ListByoipCidrsRequest listByoipCidrsRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListByoipCidrsIterable(this, this.applyPaginatorUserAgent(listByoipCidrsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomRoutingAcceleratorsResponse listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingAcceleratorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listCustomRoutingAcceleratorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingAccelerators");
            ListCustomRoutingAcceleratorsResponse listCustomRoutingAcceleratorsResponse = (ListCustomRoutingAcceleratorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingAccelerators").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomRoutingAcceleratorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomRoutingAcceleratorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomRoutingAcceleratorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listCustomRoutingAccelerators$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomRoutingAcceleratorsIterable listCustomRoutingAcceleratorsPaginator(ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListCustomRoutingAcceleratorsIterable(this, this.applyPaginatorUserAgent(listCustomRoutingAcceleratorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomRoutingEndpointGroupsResponse listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingEndpointGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listCustomRoutingEndpointGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingEndpointGroups");
            ListCustomRoutingEndpointGroupsResponse listCustomRoutingEndpointGroupsResponse = (ListCustomRoutingEndpointGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingEndpointGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomRoutingEndpointGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomRoutingEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomRoutingEndpointGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listCustomRoutingEndpointGroups$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomRoutingEndpointGroupsIterable listCustomRoutingEndpointGroupsPaginator(ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListCustomRoutingEndpointGroupsIterable(this, this.applyPaginatorUserAgent(listCustomRoutingEndpointGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomRoutingListenersResponse listCustomRoutingListeners(ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingListenersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listCustomRoutingListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingListeners");
            ListCustomRoutingListenersResponse listCustomRoutingListenersResponse = (ListCustomRoutingListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomRoutingListenersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomRoutingListenersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomRoutingListenersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listCustomRoutingListeners$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomRoutingListenersIterable listCustomRoutingListenersPaginator(ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListCustomRoutingListenersIterable(this, this.applyPaginatorUserAgent(listCustomRoutingListenersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomRoutingPortMappingsResponse listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) throws InvalidArgumentException, InvalidNextTokenException, EndpointGroupNotFoundException, AcceleratorNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listCustomRoutingPortMappingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingPortMappings");
            ListCustomRoutingPortMappingsResponse listCustomRoutingPortMappingsResponse = (ListCustomRoutingPortMappingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingPortMappings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomRoutingPortMappingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomRoutingPortMappingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomRoutingPortMappingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listCustomRoutingPortMappings$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomRoutingPortMappingsIterable listCustomRoutingPortMappingsPaginator(ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) throws InvalidArgumentException, InvalidNextTokenException, EndpointGroupNotFoundException, AcceleratorNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListCustomRoutingPortMappingsIterable(this, this.applyPaginatorUserAgent(listCustomRoutingPortMappingsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomRoutingPortMappingsByDestinationResponse listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsByDestinationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listCustomRoutingPortMappingsByDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomRoutingPortMappingsByDestination");
            ListCustomRoutingPortMappingsByDestinationResponse listCustomRoutingPortMappingsByDestinationResponse = (ListCustomRoutingPortMappingsByDestinationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomRoutingPortMappingsByDestination").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomRoutingPortMappingsByDestinationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomRoutingPortMappingsByDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomRoutingPortMappingsByDestinationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listCustomRoutingPortMappingsByDestination$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomRoutingPortMappingsByDestinationIterable listCustomRoutingPortMappingsByDestinationPaginator(ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest) throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListCustomRoutingPortMappingsByDestinationIterable(this, this.applyPaginatorUserAgent(listCustomRoutingPortMappingsByDestinationRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointGroupsResponse listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest) throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listEndpointGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpointGroups");
            ListEndpointGroupsResponse listEndpointGroupsResponse = (ListEndpointGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpointGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEndpointGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEndpointGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listEndpointGroups$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListEndpointGroupsIterable listEndpointGroupsPaginator(ListEndpointGroupsRequest listEndpointGroupsRequest) throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListEndpointGroupsIterable(this, this.applyPaginatorUserAgent(listEndpointGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListListenersResponse listListeners(ListListenersRequest listListenersRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListListenersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListListeners");
            ListListenersResponse listListenersResponse = (ListListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listListenersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListListenersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listListenersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listListeners$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListListenersIterable listListenersPaginator(ListListenersRequest listListenersRequest) throws InvalidArgumentException, AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        return new ListListenersIterable(this, this.applyPaginatorUserAgent(listListenersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$listTagsForResource$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionByoipCidrResponse provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, provisionByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvisionByoipCidr");
            ProvisionByoipCidrResponse provisionByoipCidrResponse = (ProvisionByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)provisionByoipCidrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ProvisionByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provisionByoipCidrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$provisionByoipCidr$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveCustomRoutingEndpointsResponse removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) throws EndpointGroupNotFoundException, EndpointNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveCustomRoutingEndpointsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, removeCustomRoutingEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveCustomRoutingEndpoints");
            RemoveCustomRoutingEndpointsResponse removeCustomRoutingEndpointsResponse = (RemoveCustomRoutingEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveCustomRoutingEndpoints").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeCustomRoutingEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveCustomRoutingEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeCustomRoutingEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$removeCustomRoutingEndpoints$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$tagResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$untagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAcceleratorResponse updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccelerator");
            UpdateAcceleratorResponse updateAcceleratorResponse = (UpdateAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateAccelerator$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAcceleratorAttributesResponse updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAcceleratorAttributes");
            UpdateAcceleratorAttributesResponse updateAcceleratorAttributesResponse = (UpdateAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAcceleratorAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAcceleratorAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateAcceleratorAttributes$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomRoutingAcceleratorResponse updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingAccelerator");
            UpdateCustomRoutingAcceleratorResponse updateCustomRoutingAcceleratorResponse = (UpdateCustomRoutingAcceleratorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingAccelerator").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomRoutingAcceleratorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomRoutingAcceleratorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomRoutingAcceleratorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateCustomRoutingAccelerator$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomRoutingAcceleratorAttributesResponse updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest) throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorAttributesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingAcceleratorAttributes");
            UpdateCustomRoutingAcceleratorAttributesResponse updateCustomRoutingAcceleratorAttributesResponse = (UpdateCustomRoutingAcceleratorAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingAcceleratorAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomRoutingAcceleratorAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomRoutingAcceleratorAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomRoutingAcceleratorAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateCustomRoutingAcceleratorAttributes$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomRoutingListenerResponse updateCustomRoutingListener(UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) throws InvalidArgumentException, InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomRoutingListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomRoutingListener");
            UpdateCustomRoutingListenerResponse updateCustomRoutingListenerResponse = (UpdateCustomRoutingListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomRoutingListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomRoutingListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomRoutingListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomRoutingListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateCustomRoutingListener$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointGroupResponse updateEndpointGroup(UpdateEndpointGroupRequest updateEndpointGroupRequest) throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateEndpointGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpointGroup");
            UpdateEndpointGroupResponse updateEndpointGroupResponse = (UpdateEndpointGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpointGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEndpointGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEndpointGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateEndpointGroup$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest updateListenerRequest) throws InvalidArgumentException, InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateListenerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, updateListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateListener");
            UpdateListenerResponse updateListenerResponse = (UpdateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateListenerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$updateListener$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WithdrawByoipCidrResponse withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest) throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException, IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, WithdrawByoipCidrResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultGlobalAcceleratorClient.resolveMetricPublishers(this.clientConfiguration, withdrawByoipCidrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"WithdrawByoipCidr");
            WithdrawByoipCidrResponse withdrawByoipCidrResponse = (WithdrawByoipCidrResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("WithdrawByoipCidr").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)withdrawByoipCidrRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new WithdrawByoipCidrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return withdrawByoipCidrResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultGlobalAcceleratorClient.lambda$withdrawByoipCidr$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(GlobalAcceleratorException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("EndpointNotFoundException").exceptionBuilderSupplier(EndpointNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException").exceptionBuilderSupplier(AssociatedListenerFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException").exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException").exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPortRangeException").exceptionBuilderSupplier(InvalidPortRangeException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException").exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFoundException").exceptionBuilderSupplier(ListenerNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException").exceptionBuilderSupplier(AcceleratorNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncorrectCidrStateException").exceptionBuilderSupplier(IncorrectCidrStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException").exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceErrorException").exceptionBuilderSupplier(InternalServiceErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException").exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException").exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends GlobalAcceleratorRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.209").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GlobalAcceleratorRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$withdrawByoipCidr$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateListener$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpointGroup$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingListener$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAcceleratorAttributes$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomRoutingAccelerator$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAcceleratorAttributes$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccelerator$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeCustomRoutingEndpoints$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provisionByoipCidr$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listListeners$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpointGroups$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappingsByDestination$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingPortMappings$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingListeners$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingEndpointGroups$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomRoutingAccelerators$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listByoipCidrs$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccelerators$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeListener$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpointGroup$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingListener$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingEndpointGroup$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAcceleratorAttributes$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCustomRoutingAccelerator$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAcceleratorAttributes$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccelerator$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprovisionByoipCidr$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$denyCustomRoutingTraffic$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteListener$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpointGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingListener$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingEndpointGroup$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomRoutingAccelerator$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccelerator$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createListener$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpointGroup$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingListener$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingEndpointGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomRoutingAccelerator$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccelerator$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allowCustomRoutingTraffic$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$advertiseByoipCidr$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addCustomRoutingEndpoints$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

