/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;

public class ListCustomRoutingPortMappingsByDestinationIterable
implements SdkIterable<ListCustomRoutingPortMappingsByDestinationResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCustomRoutingPortMappingsByDestinationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomRoutingPortMappingsByDestinationIterable(GlobalAcceleratorClient client, ListCustomRoutingPortMappingsByDestinationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCustomRoutingPortMappingsByDestinationResponseFetcher();
    }

    public Iterator<ListCustomRoutingPortMappingsByDestinationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DestinationPortMapping> destinationPortMappings() {
        Function<ListCustomRoutingPortMappingsByDestinationResponse, Iterator> getIterator = response -> {
            if (response != null && response.destinationPortMappings() != null) {
                return response.destinationPortMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomRoutingPortMappingsByDestinationResponseFetcher
    implements SyncPageFetcher<ListCustomRoutingPortMappingsByDestinationResponse> {
        private ListCustomRoutingPortMappingsByDestinationResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingPortMappingsByDestinationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomRoutingPortMappingsByDestinationResponse nextPage(ListCustomRoutingPortMappingsByDestinationResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingPortMappingsByDestinationIterable.this.client.listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationIterable.this.firstRequest);
            }
            return ListCustomRoutingPortMappingsByDestinationIterable.this.client.listCustomRoutingPortMappingsByDestination((ListCustomRoutingPortMappingsByDestinationRequest)((Object)ListCustomRoutingPortMappingsByDestinationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

