/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.ListLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.ListLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.LocationModel;

public class ListLocationsIterable
implements SdkIterable<ListLocationsResponse> {
    private final GameLiftClient client;
    private final ListLocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLocationsIterable(GameLiftClient client, ListLocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLocationsResponseFetcher();
    }

    public Iterator<ListLocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocationModel> locations() {
        Function<ListLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.locations() != null) {
                return response.locations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLocationsResponseFetcher
    implements SyncPageFetcher<ListLocationsResponse> {
        private ListLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLocationsResponse nextPage(ListLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListLocationsIterable.this.client.listLocations(ListLocationsIterable.this.firstRequest);
            }
            return ListLocationsIterable.this.client.listLocations((ListLocationsRequest)((Object)ListLocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

