/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType;
import software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus;
import software.amazon.awssdk.services.gamelift.model.MetricName;
import software.amazon.awssdk.services.gamelift.model.PolicyType;
import software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType;
import software.amazon.awssdk.services.gamelift.model.ScalingStatusType;
import software.amazon.awssdk.services.gamelift.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(ScalingPolicy.getter(ScalingPolicy::fleetId)).setter(ScalingPolicy.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(ScalingPolicy.getter(ScalingPolicy::fleetArn)).setter(ScalingPolicy.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScalingPolicy.getter(ScalingPolicy::name)).setter(ScalingPolicy.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ScalingPolicy.getter(ScalingPolicy::statusAsString)).setter(ScalingPolicy.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalingAdjustment").getter(ScalingPolicy.getter(ScalingPolicy::scalingAdjustment)).setter(ScalingPolicy.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<String> SCALING_ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingAdjustmentType").getter(ScalingPolicy.getter(ScalingPolicy::scalingAdjustmentTypeAsString)).setter(ScalingPolicy.setter(Builder::scalingAdjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustmentType").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(ScalingPolicy.getter(ScalingPolicy::comparisonOperatorAsString)).setter(ScalingPolicy.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(ScalingPolicy.getter(ScalingPolicy::threshold)).setter(ScalingPolicy.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(ScalingPolicy.getter(ScalingPolicy::evaluationPeriods)).setter(ScalingPolicy.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(ScalingPolicy.getter(ScalingPolicy::metricNameAsString)).setter(ScalingPolicy.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ScalingPolicy.getter(ScalingPolicy::policyTypeAsString)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::targetConfiguration)).setter(ScalingPolicy.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(ScalingPolicy.getter(ScalingPolicy::updateStatusAsString)).setter(ScalingPolicy.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(ScalingPolicy.getter(ScalingPolicy::location)).setter(ScalingPolicy.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, NAME_FIELD, STATUS_FIELD, SCALING_ADJUSTMENT_FIELD, SCALING_ADJUSTMENT_TYPE_FIELD, COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD, EVALUATION_PERIODS_FIELD, METRIC_NAME_FIELD, POLICY_TYPE_FIELD, TARGET_CONFIGURATION_FIELD, UPDATE_STATUS_FIELD, LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetId;
    private final String fleetArn;
    private final String name;
    private final String status;
    private final Integer scalingAdjustment;
    private final String scalingAdjustmentType;
    private final String comparisonOperator;
    private final Double threshold;
    private final Integer evaluationPeriods;
    private final String metricName;
    private final String policyType;
    private final TargetConfiguration targetConfiguration;
    private final String updateStatus;
    private final String location;

    private ScalingPolicy(BuilderImpl builder) {
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.name = builder.name;
        this.status = builder.status;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.policyType = builder.policyType;
        this.targetConfiguration = builder.targetConfiguration;
        this.updateStatus = builder.updateStatus;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String name() {
        return this.name;
    }

    public final ScalingStatusType status() {
        return ScalingStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public final ScalingAdjustmentType scalingAdjustmentType() {
        return ScalingAdjustmentType.fromValue(this.scalingAdjustmentType);
    }

    public final String scalingAdjustmentTypeAsString() {
        return this.scalingAdjustmentType;
    }

    public final ComparisonOperatorType comparisonOperator() {
        return ComparisonOperatorType.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final LocationUpdateStatus updateStatus() {
        return LocationUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.scalingAdjustmentTypeAsString(), other.scalingAdjustmentTypeAsString()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicy").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("ScalingAdjustmentType", (Object)this.scalingAdjustmentTypeAsString()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Threshold", (Object)this.threshold()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("MetricName", (Object)this.metricNameAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("TargetConfiguration", (Object)this.targetConfiguration()).add("UpdateStatus", (Object)this.updateStatusAsString()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "ScalingAdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustmentTypeAsString()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String name;
        private String status;
        private Integer scalingAdjustment;
        private String scalingAdjustmentType;
        private String comparisonOperator;
        private Double threshold;
        private Integer evaluationPeriods;
        private String metricName;
        private String policyType;
        private TargetConfiguration targetConfiguration;
        private String updateStatus;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.name(model.name);
            this.status(model.status);
            this.scalingAdjustment(model.scalingAdjustment);
            this.scalingAdjustmentType(model.scalingAdjustmentType);
            this.comparisonOperator(model.comparisonOperator);
            this.threshold(model.threshold);
            this.evaluationPeriods(model.evaluationPeriods);
            this.metricName(model.metricName);
            this.policyType(model.policyType);
            this.targetConfiguration(model.targetConfiguration);
            this.updateStatus(model.updateStatus);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ScalingStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final String getScalingAdjustmentType() {
            return this.scalingAdjustmentType;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType == null ? null : scalingAdjustmentType.toString());
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(LocationUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ScalingStatusType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder scalingAdjustmentType(String var1);

        public Builder scalingAdjustmentType(ScalingAdjustmentType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperatorType var1);

        public Builder threshold(Double var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder updateStatus(String var1);

        public Builder updateStatus(LocationUpdateStatus var1);

        public Builder location(String var1);
    }
}

