/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperatingSystem {
    WINDOWS_2012("WINDOWS_2012"),
    AMAZON_LINUX("AMAZON_LINUX"),
    AMAZON_LINUX_2("AMAZON_LINUX_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperatingSystem> VALUE_MAP;
    private final String value;

    private OperatingSystem(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatingSystem fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatingSystem> knownValues() {
        EnumSet<OperatingSystem> knownValues = EnumSet.allOf(OperatingSystem.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperatingSystem.class, OperatingSystem::toString);
    }
}

