/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventPredictionsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<ListEventPredictionsResponse.Builder, ListEventPredictionsResponse> {
    private static final SdkField<List<EventPredictionSummary>> EVENT_PREDICTION_SUMMARIES_FIELD = SdkField
            .<List<EventPredictionSummary>> builder(MarshallingType.LIST)
            .memberName("eventPredictionSummaries")
            .getter(getter(ListEventPredictionsResponse::eventPredictionSummaries))
            .setter(setter(Builder::eventPredictionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPredictionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventPredictionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventPredictionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEventPredictionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVENT_PREDICTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<EventPredictionSummary> eventPredictionSummaries;

    private final String nextToken;

    private ListEventPredictionsResponse(BuilderImpl builder) {
        super(builder);
        this.eventPredictionSummaries = builder.eventPredictionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventPredictionSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEventPredictionSummaries() {
        return eventPredictionSummaries != null && !(eventPredictionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summary of the past predictions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventPredictionSummaries} method.
     * </p>
     * 
     * @return The summary of the past predictions.
     */
    public final List<EventPredictionSummary> eventPredictionSummaries() {
        return eventPredictionSummaries;
    }

    /**
     * <p>
     * Identifies the next page of results to return. Use the token to make the call again to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return Identifies the next page of results to return. Use the token to make the call again to retrieve the next
     *         page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventPredictionSummaries() ? eventPredictionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventPredictionsResponse)) {
            return false;
        }
        ListEventPredictionsResponse other = (ListEventPredictionsResponse) obj;
        return hasEventPredictionSummaries() == other.hasEventPredictionSummaries()
                && Objects.equals(eventPredictionSummaries(), other.eventPredictionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventPredictionsResponse")
                .add("EventPredictionSummaries", hasEventPredictionSummaries() ? eventPredictionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventPredictionSummaries":
            return Optional.ofNullable(clazz.cast(eventPredictionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventPredictionsResponse, T> g) {
        return obj -> g.apply((ListEventPredictionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventPredictionsResponse> {
        /**
         * <p>
         * The summary of the past predictions.
         * </p>
         * 
         * @param eventPredictionSummaries
         *        The summary of the past predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPredictionSummaries(Collection<EventPredictionSummary> eventPredictionSummaries);

        /**
         * <p>
         * The summary of the past predictions.
         * </p>
         * 
         * @param eventPredictionSummaries
         *        The summary of the past predictions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPredictionSummaries(EventPredictionSummary... eventPredictionSummaries);

        /**
         * <p>
         * The summary of the past predictions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.EventPredictionSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.EventPredictionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.EventPredictionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #eventPredictionSummaries(List<EventPredictionSummary>)}.
         * 
         * @param eventPredictionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.EventPredictionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventPredictionSummaries(java.util.Collection<EventPredictionSummary>)
         */
        Builder eventPredictionSummaries(Consumer<EventPredictionSummary.Builder>... eventPredictionSummaries);

        /**
         * <p>
         * Identifies the next page of results to return. Use the token to make the call again to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return. Use the token to make the call again to retrieve the
         *        next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<EventPredictionSummary> eventPredictionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventPredictionsResponse model) {
            super(model);
            eventPredictionSummaries(model.eventPredictionSummaries);
            nextToken(model.nextToken);
        }

        public final List<EventPredictionSummary.Builder> getEventPredictionSummaries() {
            List<EventPredictionSummary.Builder> result = ListOfEventPredictionSummariesCopier
                    .copyToBuilder(this.eventPredictionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventPredictionSummaries(Collection<EventPredictionSummary.BuilderImpl> eventPredictionSummaries) {
            this.eventPredictionSummaries = ListOfEventPredictionSummariesCopier.copyFromBuilder(eventPredictionSummaries);
        }

        @Override
        public final Builder eventPredictionSummaries(Collection<EventPredictionSummary> eventPredictionSummaries) {
            this.eventPredictionSummaries = ListOfEventPredictionSummariesCopier.copy(eventPredictionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPredictionSummaries(EventPredictionSummary... eventPredictionSummaries) {
            eventPredictionSummaries(Arrays.asList(eventPredictionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPredictionSummaries(Consumer<EventPredictionSummary.Builder>... eventPredictionSummaries) {
            eventPredictionSummaries(Stream.of(eventPredictionSummaries)
                    .map(c -> EventPredictionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEventPredictionsResponse build() {
            return new ListEventPredictionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
