/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDetectorVersionResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetDetectorVersionResponse.Builder, GetDetectorVersionResponse> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(GetDetectorVersionResponse::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(GetDetectorVersionResponse::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetDetectorVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> EXTERNAL_MODEL_ENDPOINTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("externalModelEndpoints")
            .getter(getter(GetDetectorVersionResponse::externalModelEndpoints))
            .setter(setter(Builder::externalModelEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModelEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModelVersion>> MODEL_VERSIONS_FIELD = SdkField
            .<List<ModelVersion>> builder(MarshallingType.LIST)
            .memberName("modelVersions")
            .getter(getter(GetDetectorVersionResponse::modelVersions))
            .setter(setter(Builder::modelVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(GetDetectorVersionResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetDetectorVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(GetDetectorVersionResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(GetDetectorVersionResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleExecutionMode").getter(getter(GetDetectorVersionResponse::ruleExecutionModeAsString))
            .setter(setter(Builder::ruleExecutionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetDetectorVersionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_ID_FIELD, DESCRIPTION_FIELD, EXTERNAL_MODEL_ENDPOINTS_FIELD, MODEL_VERSIONS_FIELD, RULES_FIELD,
            STATUS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, RULE_EXECUTION_MODE_FIELD, ARN_FIELD));

    private final String detectorId;

    private final String detectorVersionId;

    private final String description;

    private final List<String> externalModelEndpoints;

    private final List<ModelVersion> modelVersions;

    private final List<Rule> rules;

    private final String status;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String ruleExecutionMode;

    private final String arn;

    private GetDetectorVersionResponse(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.description = builder.description;
        this.externalModelEndpoints = builder.externalModelEndpoints;
        this.modelVersions = builder.modelVersions;
        this.rules = builder.rules;
        this.status = builder.status;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.ruleExecutionMode = builder.ruleExecutionMode;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The detector version description.
     * </p>
     * 
     * @return The detector version description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalModelEndpoints property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExternalModelEndpoints() {
        return externalModelEndpoints != null && !(externalModelEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon SageMaker model endpoints included in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalModelEndpoints} method.
     * </p>
     * 
     * @return The Amazon SageMaker model endpoints included in the detector version.
     */
    public final List<String> externalModelEndpoints() {
        return externalModelEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelVersions() {
        return modelVersions != null && !(modelVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model versions included in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVersions} method.
     * </p>
     * 
     * @return The model versions included in the detector version.
     */
    public final List<ModelVersion> modelVersions() {
        return modelVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules included in the detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules included in the detector version.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * The status of the detector version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector version.
     * @see DetectorVersionStatus
     */
    public final DetectorVersionStatus status() {
        return DetectorVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the detector version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector version.
     * @see DetectorVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the detector version was last updated.
     * </p>
     * 
     * @return The timestamp when the detector version was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The timestamp when the detector version was created.
     * </p>
     * 
     * @return The timestamp when the detector version was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The execution mode of the rule in the dectector
     * </p>
     * <p>
     * <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last,
     * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
     * </p>
     * <p>
     * <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for
     * all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft
     * status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The execution mode of the rule in the dectector</p>
     *         <p>
     *         <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to
     *         last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
     *         single rule.
     *         </p>
     *         <p>
     *         <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the
     *         outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when
     *         it is in draft status.
     * @see RuleExecutionMode
     */
    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(ruleExecutionMode);
    }

    /**
     * <p>
     * The execution mode of the rule in the dectector
     * </p>
     * <p>
     * <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last,
     * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
     * </p>
     * <p>
     * <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes for
     * all matched rules. You can define and edit the rule mode at the detector version level, when it is in draft
     * status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleExecutionMode}
     * will return {@link RuleExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleExecutionModeAsString}.
     * </p>
     * 
     * @return The execution mode of the rule in the dectector</p>
     *         <p>
     *         <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to
     *         last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
     *         single rule.
     *         </p>
     *         <p>
     *         <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the
     *         outcomes for all matched rules. You can define and edit the rule mode at the detector version level, when
     *         it is in draft status.
     * @see RuleExecutionMode
     */
    public final String ruleExecutionModeAsString() {
        return ruleExecutionMode;
    }

    /**
     * <p>
     * The detector version ARN.
     * </p>
     * 
     * @return The detector version ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalModelEndpoints() ? externalModelEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVersions() ? modelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(ruleExecutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorVersionResponse)) {
            return false;
        }
        GetDetectorVersionResponse other = (GetDetectorVersionResponse) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(description(), other.description())
                && hasExternalModelEndpoints() == other.hasExternalModelEndpoints()
                && Objects.equals(externalModelEndpoints(), other.externalModelEndpoints())
                && hasModelVersions() == other.hasModelVersions() && Objects.equals(modelVersions(), other.modelVersions())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(ruleExecutionModeAsString(), other.ruleExecutionModeAsString())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDetectorVersionResponse").add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId()).add("Description", description())
                .add("ExternalModelEndpoints", hasExternalModelEndpoints() ? externalModelEndpoints() : null)
                .add("ModelVersions", hasModelVersions() ? modelVersions() : null).add("Rules", hasRules() ? rules() : null)
                .add("Status", statusAsString()).add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime())
                .add("RuleExecutionMode", ruleExecutionModeAsString()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "externalModelEndpoints":
            return Optional.ofNullable(clazz.cast(externalModelEndpoints()));
        case "modelVersions":
            return Optional.ofNullable(clazz.cast(modelVersions()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ruleExecutionMode":
            return Optional.ofNullable(clazz.cast(ruleExecutionModeAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorVersionResponse, T> g) {
        return obj -> g.apply((GetDetectorVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDetectorVersionResponse> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The detector version description.
         * </p>
         * 
         * @param description
         *        The detector version description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon SageMaker model endpoints included in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon SageMaker model endpoints included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(Collection<String> externalModelEndpoints);

        /**
         * <p>
         * The Amazon SageMaker model endpoints included in the detector version.
         * </p>
         * 
         * @param externalModelEndpoints
         *        The Amazon SageMaker model endpoints included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalModelEndpoints(String... externalModelEndpoints);

        /**
         * <p>
         * The model versions included in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(Collection<ModelVersion> modelVersions);

        /**
         * <p>
         * The model versions included in the detector version.
         * </p>
         * 
         * @param modelVersions
         *        The model versions included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersions(ModelVersion... modelVersions);

        /**
         * <p>
         * The model versions included in the detector version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.ModelVersion.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.ModelVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.ModelVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #modelVersions(List<ModelVersion>)}.
         * 
         * @param modelVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.ModelVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersions(java.util.Collection<ModelVersion>)
         */
        Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions);

        /**
         * <p>
         * The rules included in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The rules included in the detector version.
         * </p>
         * 
         * @param rules
         *        The rules included in the detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The rules included in the detector version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.frauddetector.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.Rule.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The status of the detector version.
         * </p>
         * 
         * @param status
         *        The status of the detector version.
         * @see DetectorVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the detector version.
         * </p>
         * 
         * @param status
         *        The status of the detector version.
         * @see DetectorVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorVersionStatus
         */
        Builder status(DetectorVersionStatus status);

        /**
         * <p>
         * The timestamp when the detector version was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the detector version was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The timestamp when the detector version was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the detector version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The execution mode of the rule in the dectector
         * </p>
         * <p>
         * <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last,
         * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
         * </p>
         * <p>
         * <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes
         * for all matched rules. You can define and edit the rule mode at the detector version level, when it is in
         * draft status.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The execution mode of the rule in the dectector</p>
         *        <p>
         *        <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to
         *        last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
         *        single rule.
         *        </p>
         *        <p>
         *        <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the
         *        outcomes for all matched rules. You can define and edit the rule mode at the detector version level,
         *        when it is in draft status.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(String ruleExecutionMode);

        /**
         * <p>
         * The execution mode of the rule in the dectector
         * </p>
         * <p>
         * <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to last,
         * stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that single rule.
         * </p>
         * <p>
         * <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the outcomes
         * for all matched rules. You can define and edit the rule mode at the detector version level, when it is in
         * draft status.
         * </p>
         * 
         * @param ruleExecutionMode
         *        The execution mode of the rule in the dectector</p>
         *        <p>
         *        <code>FIRST_MATCHED</code> indicates that Amazon Fraud Detector evaluates rules sequentially, first to
         *        last, stopping at the first matched rule. Amazon Fraud dectector then provides the outcomes for that
         *        single rule.
         *        </p>
         *        <p>
         *        <code>ALL_MATCHED</code> indicates that Amazon Fraud Detector evaluates all rules and returns the
         *        outcomes for all matched rules. You can define and edit the rule mode at the detector version level,
         *        when it is in draft status.
         * @see RuleExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleExecutionMode
         */
        Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode);

        /**
         * <p>
         * The detector version ARN.
         * </p>
         * 
         * @param arn
         *        The detector version ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String detectorId;

        private String detectorVersionId;

        private String description;

        private List<String> externalModelEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<ModelVersion> modelVersions = DefaultSdkAutoConstructList.getInstance();

        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String lastUpdatedTime;

        private String createdTime;

        private String ruleExecutionMode;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorVersionResponse model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            description(model.description);
            externalModelEndpoints(model.externalModelEndpoints);
            modelVersions(model.modelVersions);
            rules(model.rules);
            status(model.status);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            ruleExecutionMode(model.ruleExecutionMode);
            arn(model.arn);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getExternalModelEndpoints() {
            if (externalModelEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return externalModelEndpoints;
        }

        public final void setExternalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
        }

        @Override
        public final Builder externalModelEndpoints(Collection<String> externalModelEndpoints) {
            this.externalModelEndpoints = ListOfStringsCopier.copy(externalModelEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalModelEndpoints(String... externalModelEndpoints) {
            externalModelEndpoints(Arrays.asList(externalModelEndpoints));
            return this;
        }

        public final List<ModelVersion.Builder> getModelVersions() {
            List<ModelVersion.Builder> result = ListOfModelVersionsCopier.copyToBuilder(this.modelVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersions(Collection<ModelVersion.BuilderImpl> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copyFromBuilder(modelVersions);
        }

        @Override
        public final Builder modelVersions(Collection<ModelVersion> modelVersions) {
            this.modelVersions = ListOfModelVersionsCopier.copy(modelVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(ModelVersion... modelVersions) {
            modelVersions(Arrays.asList(modelVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersions(Consumer<ModelVersion.Builder>... modelVersions) {
            modelVersions(Stream.of(modelVersions).map(c -> ModelVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getRuleExecutionMode() {
            return ruleExecutionMode;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetDetectorVersionResponse build() {
            return new GetDetectorVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
