/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The batch import job details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchImport implements SdkPojo, Serializable, ToCopyableBuilder<BatchImport.Builder, BatchImport> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(BatchImport::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchImport::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(BatchImport::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(BatchImport::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> COMPLETION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("completionTime").getter(getter(BatchImport::completionTime)).setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build()).build();

    private static final SdkField<String> INPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputPath").getter(getter(BatchImport::inputPath)).setter(setter(Builder::inputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPath").build()).build();

    private static final SdkField<String> OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputPath").getter(getter(BatchImport::outputPath)).setter(setter(Builder::outputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputPath").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(BatchImport::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(BatchImport::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(BatchImport::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("processedRecordsCount").getter(getter(BatchImport::processedRecordsCount))
            .setter(setter(Builder::processedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedRecordsCount").build())
            .build();

    private static final SdkField<Integer> FAILED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedRecordsCount").getter(getter(BatchImport::failedRecordsCount))
            .setter(setter(Builder::failedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecordsCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecordsCount").getter(getter(BatchImport::totalRecordsCount))
            .setter(setter(Builder::totalRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD,
            FAILURE_REASON_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, INPUT_PATH_FIELD, OUTPUT_PATH_FIELD,
            EVENT_TYPE_NAME_FIELD, IAM_ROLE_ARN_FIELD, ARN_FIELD, PROCESSED_RECORDS_COUNT_FIELD, FAILED_RECORDS_COUNT_FIELD,
            TOTAL_RECORDS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String status;

    private final String failureReason;

    private final String startTime;

    private final String completionTime;

    private final String inputPath;

    private final String outputPath;

    private final String eventTypeName;

    private final String iamRoleArn;

    private final String arn;

    private final Integer processedRecordsCount;

    private final Integer failedRecordsCount;

    private final Integer totalRecordsCount;

    private BatchImport(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.inputPath = builder.inputPath;
        this.outputPath = builder.outputPath;
        this.eventTypeName = builder.eventTypeName;
        this.iamRoleArn = builder.iamRoleArn;
        this.arn = builder.arn;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.failedRecordsCount = builder.failedRecordsCount;
        this.totalRecordsCount = builder.totalRecordsCount;
    }

    /**
     * <p>
     * The ID of the batch import job.
     * </p>
     * 
     * @return The ID of the batch import job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status of the batch import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch import job.
     * @see AsyncJobStatus
     */
    public final AsyncJobStatus status() {
        return AsyncJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the batch import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the batch import job.
     * @see AsyncJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason batch import job failed.
     * </p>
     * 
     * @return The reason batch import job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Timestamp of when the batch import job started.
     * </p>
     * 
     * @return Timestamp of when the batch import job started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * Timestamp of when batch import job completed.
     * </p>
     * 
     * @return Timestamp of when batch import job completed.
     */
    public final String completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The Amazon S3 location of your data file for batch import.
     * </p>
     * 
     * @return The Amazon S3 location of your data file for batch import.
     */
    public final String inputPath() {
        return inputPath;
    }

    /**
     * <p>
     * The Amazon S3 location of your output file.
     * </p>
     * 
     * @return The Amazon S3 location of your output file.
     */
    public final String outputPath() {
        return outputPath;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @return The name of the event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The ARN of the IAM role to use for this job request.
     * </p>
     * 
     * @return The ARN of the IAM role to use for this job request.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ARN of the batch import job.
     * </p>
     * 
     * @return The ARN of the batch import job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The number of records processed by batch import job.
     * </p>
     * 
     * @return The number of records processed by batch import job.
     */
    public final Integer processedRecordsCount() {
        return processedRecordsCount;
    }

    /**
     * <p>
     * The number of records that failed to import.
     * </p>
     * 
     * @return The number of records that failed to import.
     */
    public final Integer failedRecordsCount() {
        return failedRecordsCount;
    }

    /**
     * <p>
     * The total number of records in the batch import job.
     * </p>
     * 
     * @return The total number of records in the batch import job.
     */
    public final Integer totalRecordsCount() {
        return totalRecordsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(outputPath());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchImport)) {
            return false;
        }
        BatchImport other = (BatchImport) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(inputPath(), other.inputPath())
                && Objects.equals(outputPath(), other.outputPath()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(arn(), other.arn())
                && Objects.equals(processedRecordsCount(), other.processedRecordsCount())
                && Objects.equals(failedRecordsCount(), other.failedRecordsCount())
                && Objects.equals(totalRecordsCount(), other.totalRecordsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchImport").add("JobId", jobId()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("StartTime", startTime()).add("CompletionTime", completionTime())
                .add("InputPath", inputPath()).add("OutputPath", outputPath()).add("EventTypeName", eventTypeName())
                .add("IamRoleArn", iamRoleArn()).add("Arn", arn()).add("ProcessedRecordsCount", processedRecordsCount())
                .add("FailedRecordsCount", failedRecordsCount()).add("TotalRecordsCount", totalRecordsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "completionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "inputPath":
            return Optional.ofNullable(clazz.cast(inputPath()));
        case "outputPath":
            return Optional.ofNullable(clazz.cast(outputPath()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "processedRecordsCount":
            return Optional.ofNullable(clazz.cast(processedRecordsCount()));
        case "failedRecordsCount":
            return Optional.ofNullable(clazz.cast(failedRecordsCount()));
        case "totalRecordsCount":
            return Optional.ofNullable(clazz.cast(totalRecordsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchImport, T> g) {
        return obj -> g.apply((BatchImport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchImport> {
        /**
         * <p>
         * The ID of the batch import job.
         * </p>
         * 
         * @param jobId
         *        The ID of the batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status of the batch import job.
         * </p>
         * 
         * @param status
         *        The status of the batch import job.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the batch import job.
         * </p>
         * 
         * @param status
         *        The status of the batch import job.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder status(AsyncJobStatus status);

        /**
         * <p>
         * The reason batch import job failed.
         * </p>
         * 
         * @param failureReason
         *        The reason batch import job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Timestamp of when the batch import job started.
         * </p>
         * 
         * @param startTime
         *        Timestamp of when the batch import job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * Timestamp of when batch import job completed.
         * </p>
         * 
         * @param completionTime
         *        Timestamp of when batch import job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(String completionTime);

        /**
         * <p>
         * The Amazon S3 location of your data file for batch import.
         * </p>
         * 
         * @param inputPath
         *        The Amazon S3 location of your data file for batch import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputPath(String inputPath);

        /**
         * <p>
         * The Amazon S3 location of your output file.
         * </p>
         * 
         * @param outputPath
         *        The Amazon S3 location of your output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPath(String outputPath);

        /**
         * <p>
         * The name of the event type.
         * </p>
         * 
         * @param eventTypeName
         *        The name of the event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The ARN of the IAM role to use for this job request.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role to use for this job request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ARN of the batch import job.
         * </p>
         * 
         * @param arn
         *        The ARN of the batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The number of records processed by batch import job.
         * </p>
         * 
         * @param processedRecordsCount
         *        The number of records processed by batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedRecordsCount(Integer processedRecordsCount);

        /**
         * <p>
         * The number of records that failed to import.
         * </p>
         * 
         * @param failedRecordsCount
         *        The number of records that failed to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordsCount(Integer failedRecordsCount);

        /**
         * <p>
         * The total number of records in the batch import job.
         * </p>
         * 
         * @param totalRecordsCount
         *        The total number of records in the batch import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordsCount(Integer totalRecordsCount);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String status;

        private String failureReason;

        private String startTime;

        private String completionTime;

        private String inputPath;

        private String outputPath;

        private String eventTypeName;

        private String iamRoleArn;

        private String arn;

        private Integer processedRecordsCount;

        private Integer failedRecordsCount;

        private Integer totalRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchImport model) {
            jobId(model.jobId);
            status(model.status);
            failureReason(model.failureReason);
            startTime(model.startTime);
            completionTime(model.completionTime);
            inputPath(model.inputPath);
            outputPath(model.outputPath);
            eventTypeName(model.eventTypeName);
            iamRoleArn(model.iamRoleArn);
            arn(model.arn);
            processedRecordsCount(model.processedRecordsCount);
            failedRecordsCount(model.failedRecordsCount);
            totalRecordsCount(model.totalRecordsCount);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AsyncJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(String completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(String completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getInputPath() {
            return inputPath;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final String getOutputPath() {
            return outputPath;
        }

        public final void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        @Override
        public final Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getProcessedRecordsCount() {
            return processedRecordsCount;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final Integer getFailedRecordsCount() {
            return failedRecordsCount;
        }

        public final void setFailedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
        }

        @Override
        public final Builder failedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
            return this;
        }

        public final Integer getTotalRecordsCount() {
            return totalRecordsCount;
        }

        public final void setTotalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
        }

        @Override
        public final Builder totalRecordsCount(Integer totalRecordsCount) {
            this.totalRecordsCount = totalRecordsCount;
            return this;
        }

        @Override
        public BatchImport build() {
            return new BatchImport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
