/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Account Takeover Insights (ATI) model performance score.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ATIModelPerformance implements SdkPojo, Serializable,
        ToCopyableBuilder<ATIModelPerformance.Builder, ATIModelPerformance> {
    private static final SdkField<Float> ASI_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("asi")
            .getter(getter(ATIModelPerformance::asi)).setter(setter(Builder::asi))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASI_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float asi;

    private ATIModelPerformance(BuilderImpl builder) {
        this.asi = builder.asi;
    }

    /**
     * <p>
     * The anomaly separation index (ASI) score. This metric summarizes the overall ability of the model to separate
     * anomalous activities from the normal behavior. Depending on the business, a large fraction of these anomalous
     * activities can be malicious and correspond to the account takeover attacks. A model with no separability power
     * will have the lowest possible ASI score of 0.5, whereas the a model with a high separability power will have the
     * highest possible ASI score of 1.0
     * </p>
     * 
     * @return The anomaly separation index (ASI) score. This metric summarizes the overall ability of the model to
     *         separate anomalous activities from the normal behavior. Depending on the business, a large fraction of
     *         these anomalous activities can be malicious and correspond to the account takeover attacks. A model with
     *         no separability power will have the lowest possible ASI score of 0.5, whereas the a model with a high
     *         separability power will have the highest possible ASI score of 1.0
     */
    public final Float asi() {
        return asi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ATIModelPerformance)) {
            return false;
        }
        ATIModelPerformance other = (ATIModelPerformance) obj;
        return Objects.equals(asi(), other.asi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ATIModelPerformance").add("Asi", asi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "asi":
            return Optional.ofNullable(clazz.cast(asi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ATIModelPerformance, T> g) {
        return obj -> g.apply((ATIModelPerformance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ATIModelPerformance> {
        /**
         * <p>
         * The anomaly separation index (ASI) score. This metric summarizes the overall ability of the model to separate
         * anomalous activities from the normal behavior. Depending on the business, a large fraction of these anomalous
         * activities can be malicious and correspond to the account takeover attacks. A model with no separability
         * power will have the lowest possible ASI score of 0.5, whereas the a model with a high separability power will
         * have the highest possible ASI score of 1.0
         * </p>
         * 
         * @param asi
         *        The anomaly separation index (ASI) score. This metric summarizes the overall ability of the model to
         *        separate anomalous activities from the normal behavior. Depending on the business, a large fraction of
         *        these anomalous activities can be malicious and correspond to the account takeover attacks. A model
         *        with no separability power will have the lowest possible ASI score of 0.5, whereas the a model with a
         *        high separability power will have the highest possible ASI score of 1.0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asi(Float asi);
    }

    static final class BuilderImpl implements Builder {
        private Float asi;

        private BuilderImpl() {
        }

        private BuilderImpl(ATIModelPerformance model) {
            asi(model.asi);
        }

        public final Float getAsi() {
            return asi;
        }

        public final void setAsi(Float asi) {
            this.asi = asi;
        }

        @Override
        public final Builder asi(Float asi) {
            this.asi = asi;
            return this;
        }

        @Override
        public ATIModelPerformance build() {
            return new ATIModelPerformance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
