/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The variable importance metrics details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VariableImportanceMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<VariableImportanceMetrics.Builder, VariableImportanceMetrics> {
    private static final SdkField<List<LogOddsMetric>> LOG_ODDS_METRICS_FIELD = SdkField
            .<List<LogOddsMetric>> builder(MarshallingType.LIST)
            .memberName("logOddsMetrics")
            .getter(getter(VariableImportanceMetrics::logOddsMetrics))
            .setter(setter(Builder::logOddsMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logOddsMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogOddsMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogOddsMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ODDS_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogOddsMetric> logOddsMetrics;

    private VariableImportanceMetrics(BuilderImpl builder) {
        this.logOddsMetrics = builder.logOddsMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogOddsMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogOddsMetrics() {
        return logOddsMetrics != null && !(logOddsMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of variable metrics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogOddsMetrics} method.
     * </p>
     * 
     * @return List of variable metrics.
     */
    public final List<LogOddsMetric> logOddsMetrics() {
        return logOddsMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogOddsMetrics() ? logOddsMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableImportanceMetrics)) {
            return false;
        }
        VariableImportanceMetrics other = (VariableImportanceMetrics) obj;
        return hasLogOddsMetrics() == other.hasLogOddsMetrics() && Objects.equals(logOddsMetrics(), other.logOddsMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VariableImportanceMetrics").add("LogOddsMetrics", hasLogOddsMetrics() ? logOddsMetrics() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logOddsMetrics":
            return Optional.ofNullable(clazz.cast(logOddsMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableImportanceMetrics, T> g) {
        return obj -> g.apply((VariableImportanceMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VariableImportanceMetrics> {
        /**
         * <p>
         * List of variable metrics.
         * </p>
         * 
         * @param logOddsMetrics
         *        List of variable metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logOddsMetrics(Collection<LogOddsMetric> logOddsMetrics);

        /**
         * <p>
         * List of variable metrics.
         * </p>
         * 
         * @param logOddsMetrics
         *        List of variable metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logOddsMetrics(LogOddsMetric... logOddsMetrics);

        /**
         * <p>
         * List of variable metrics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.LogOddsMetric.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.LogOddsMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.LogOddsMetric.Builder#build()} is called
         * immediately and its result is passed to {@link #logOddsMetrics(List<LogOddsMetric>)}.
         * 
         * @param logOddsMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.LogOddsMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logOddsMetrics(java.util.Collection<LogOddsMetric>)
         */
        Builder logOddsMetrics(Consumer<LogOddsMetric.Builder>... logOddsMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<LogOddsMetric> logOddsMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VariableImportanceMetrics model) {
            logOddsMetrics(model.logOddsMetrics);
        }

        public final List<LogOddsMetric.Builder> getLogOddsMetrics() {
            List<LogOddsMetric.Builder> result = ListOfLogOddsMetricsCopier.copyToBuilder(this.logOddsMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogOddsMetrics(Collection<LogOddsMetric.BuilderImpl> logOddsMetrics) {
            this.logOddsMetrics = ListOfLogOddsMetricsCopier.copyFromBuilder(logOddsMetrics);
        }

        @Override
        public final Builder logOddsMetrics(Collection<LogOddsMetric> logOddsMetrics) {
            this.logOddsMetrics = ListOfLogOddsMetricsCopier.copy(logOddsMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logOddsMetrics(LogOddsMetric... logOddsMetrics) {
            logOddsMetrics(Arrays.asList(logOddsMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logOddsMetrics(Consumer<LogOddsMetric.Builder>... logOddsMetrics) {
            logOddsMetrics(Stream.of(logOddsMetrics).map(c -> LogOddsMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VariableImportanceMetrics build() {
            return new VariableImportanceMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
