/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Account Takeover Insights (ATI) model performance metrics data points.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ATIMetricDataPoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ATIMetricDataPoint.Builder, ATIMetricDataPoint> {
    private static final SdkField<Float> CR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("cr")
            .getter(getter(ATIMetricDataPoint::cr)).setter(setter(Builder::cr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cr").build()).build();

    private static final SdkField<Float> ADR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("adr")
            .getter(getter(ATIMetricDataPoint::adr)).setter(setter(Builder::adr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adr").build()).build();

    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("threshold").getter(getter(ATIMetricDataPoint::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<Float> ATODR_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("atodr")
            .getter(getter(ATIMetricDataPoint::atodr)).setter(setter(Builder::atodr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atodr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CR_FIELD, ADR_FIELD,
            THRESHOLD_FIELD, ATODR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float cr;

    private final Float adr;

    private final Float threshold;

    private final Float atodr;

    private ATIMetricDataPoint(BuilderImpl builder) {
        this.cr = builder.cr;
        this.adr = builder.adr;
        this.threshold = builder.threshold;
        this.atodr = builder.atodr;
    }

    /**
     * <p>
     * The challenge rate. This indicates the percentage of login events that the model recommends to challenge such as
     * one-time password, multi-factor authentication, and investigations.
     * </p>
     * 
     * @return The challenge rate. This indicates the percentage of login events that the model recommends to challenge
     *         such as one-time password, multi-factor authentication, and investigations.
     */
    public final Float cr() {
        return cr;
    }

    /**
     * <p>
     * The anomaly discovery rate. This metric quantifies the percentage of anomalies that can be detected by the model
     * at the selected score threshold. A lower score threshold increases the percentage of anomalies captured by the
     * model, but would also require challenging a larger percentage of login events, leading to a higher customer
     * friction.
     * </p>
     * 
     * @return The anomaly discovery rate. This metric quantifies the percentage of anomalies that can be detected by
     *         the model at the selected score threshold. A lower score threshold increases the percentage of anomalies
     *         captured by the model, but would also require challenging a larger percentage of login events, leading to
     *         a higher customer friction.
     */
    public final Float adr() {
        return adr;
    }

    /**
     * <p>
     * The model's threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means any
     * model score 500 or above is labeled as fraud.
     * </p>
     * 
     * @return The model's threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500
     *         means any model score 500 or above is labeled as fraud.
     */
    public final Float threshold() {
        return threshold;
    }

    /**
     * <p>
     * The account takeover discovery rate. This metric quantifies the percentage of account compromise events that can
     * be detected by the model at the selected score threshold. This metric is only available if 50 or more entities
     * with at-least one labeled account takeover event is present in the ingested dataset.
     * </p>
     * 
     * @return The account takeover discovery rate. This metric quantifies the percentage of account compromise events
     *         that can be detected by the model at the selected score threshold. This metric is only available if 50 or
     *         more entities with at-least one labeled account takeover event is present in the ingested dataset.
     */
    public final Float atodr() {
        return atodr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cr());
        hashCode = 31 * hashCode + Objects.hashCode(adr());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(atodr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ATIMetricDataPoint)) {
            return false;
        }
        ATIMetricDataPoint other = (ATIMetricDataPoint) obj;
        return Objects.equals(cr(), other.cr()) && Objects.equals(adr(), other.adr())
                && Objects.equals(threshold(), other.threshold()) && Objects.equals(atodr(), other.atodr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ATIMetricDataPoint").add("Cr", cr()).add("Adr", adr()).add("Threshold", threshold())
                .add("Atodr", atodr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cr":
            return Optional.ofNullable(clazz.cast(cr()));
        case "adr":
            return Optional.ofNullable(clazz.cast(adr()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "atodr":
            return Optional.ofNullable(clazz.cast(atodr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ATIMetricDataPoint, T> g) {
        return obj -> g.apply((ATIMetricDataPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ATIMetricDataPoint> {
        /**
         * <p>
         * The challenge rate. This indicates the percentage of login events that the model recommends to challenge such
         * as one-time password, multi-factor authentication, and investigations.
         * </p>
         * 
         * @param cr
         *        The challenge rate. This indicates the percentage of login events that the model recommends to
         *        challenge such as one-time password, multi-factor authentication, and investigations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cr(Float cr);

        /**
         * <p>
         * The anomaly discovery rate. This metric quantifies the percentage of anomalies that can be detected by the
         * model at the selected score threshold. A lower score threshold increases the percentage of anomalies captured
         * by the model, but would also require challenging a larger percentage of login events, leading to a higher
         * customer friction.
         * </p>
         * 
         * @param adr
         *        The anomaly discovery rate. This metric quantifies the percentage of anomalies that can be detected by
         *        the model at the selected score threshold. A lower score threshold increases the percentage of
         *        anomalies captured by the model, but would also require challenging a larger percentage of login
         *        events, leading to a higher customer friction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adr(Float adr);

        /**
         * <p>
         * The model's threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500 means
         * any model score 500 or above is labeled as fraud.
         * </p>
         * 
         * @param threshold
         *        The model's threshold that specifies an acceptable fraud capture rate. For example, a threshold of 500
         *        means any model score 500 or above is labeled as fraud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Float threshold);

        /**
         * <p>
         * The account takeover discovery rate. This metric quantifies the percentage of account compromise events that
         * can be detected by the model at the selected score threshold. This metric is only available if 50 or more
         * entities with at-least one labeled account takeover event is present in the ingested dataset.
         * </p>
         * 
         * @param atodr
         *        The account takeover discovery rate. This metric quantifies the percentage of account compromise
         *        events that can be detected by the model at the selected score threshold. This metric is only
         *        available if 50 or more entities with at-least one labeled account takeover event is present in the
         *        ingested dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atodr(Float atodr);
    }

    static final class BuilderImpl implements Builder {
        private Float cr;

        private Float adr;

        private Float threshold;

        private Float atodr;

        private BuilderImpl() {
        }

        private BuilderImpl(ATIMetricDataPoint model) {
            cr(model.cr);
            adr(model.adr);
            threshold(model.threshold);
            atodr(model.atodr);
        }

        public final Float getCr() {
            return cr;
        }

        public final void setCr(Float cr) {
            this.cr = cr;
        }

        @Override
        public final Builder cr(Float cr) {
            this.cr = cr;
            return this;
        }

        public final Float getAdr() {
            return adr;
        }

        public final void setAdr(Float adr) {
            this.adr = adr;
        }

        @Override
        public final Builder adr(Float adr) {
            this.adr = adr;
            return this;
        }

        public final Float getThreshold() {
            return threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        public final Float getAtodr() {
            return atodr;
        }

        public final void setAtodr(Float atodr) {
            this.atodr = atodr;
        }

        @Override
        public final Builder atodr(Float atodr) {
            this.atodr = atodr;
            return this;
        }

        @Override
        public ATIMetricDataPoint build() {
            return new ATIMetricDataPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
