/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutKmsEncryptionKeyRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<PutKmsEncryptionKeyRequest.Builder, PutKmsEncryptionKeyRequest> {
    private static final SdkField<String> KMS_ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsEncryptionKeyArn").getter(getter(PutKmsEncryptionKeyRequest::kmsEncryptionKeyArn))
            .setter(setter(Builder::kmsEncryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKeyArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ENCRYPTION_KEY_ARN_FIELD));

    private final String kmsEncryptionKeyArn;

    private PutKmsEncryptionKeyRequest(BuilderImpl builder) {
        super(builder);
        this.kmsEncryptionKeyArn = builder.kmsEncryptionKeyArn;
    }

    /**
     * <p>
     * The KMS encryption key ARN.
     * </p>
     * <p>
     * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     * </p>
     * 
     * @return The KMS encryption key ARN.</p>
     *         <p>
     *         The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
     */
    public final String kmsEncryptionKeyArn() {
        return kmsEncryptionKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutKmsEncryptionKeyRequest)) {
            return false;
        }
        PutKmsEncryptionKeyRequest other = (PutKmsEncryptionKeyRequest) obj;
        return Objects.equals(kmsEncryptionKeyArn(), other.kmsEncryptionKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutKmsEncryptionKeyRequest").add("KmsEncryptionKeyArn", kmsEncryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsEncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(kmsEncryptionKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutKmsEncryptionKeyRequest, T> g) {
        return obj -> g.apply((PutKmsEncryptionKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutKmsEncryptionKeyRequest> {
        /**
         * <p>
         * The KMS encryption key ARN.
         * </p>
         * <p>
         * The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
         * </p>
         * 
         * @param kmsEncryptionKeyArn
         *        The KMS encryption key ARN.</p>
         *        <p>
         *        The KMS key must be single-Region key. Amazon Fraud Detector does not support multi-Region KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionKeyArn(String kmsEncryptionKeyArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String kmsEncryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutKmsEncryptionKeyRequest model) {
            super(model);
            kmsEncryptionKeyArn(model.kmsEncryptionKeyArn);
        }

        public final String getKmsEncryptionKeyArn() {
            return kmsEncryptionKeyArn;
        }

        public final void setKmsEncryptionKeyArn(String kmsEncryptionKeyArn) {
            this.kmsEncryptionKeyArn = kmsEncryptionKeyArn;
        }

        @Override
        public final Builder kmsEncryptionKeyArn(String kmsEncryptionKeyArn) {
            this.kmsEncryptionKeyArn = kmsEncryptionKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutKmsEncryptionKeyRequest build() {
            return new PutKmsEncryptionKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
