/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKmsEncryptionKeyResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetKmsEncryptionKeyResponse.Builder, GetKmsEncryptionKeyResponse> {
    private static final SdkField<KMSKey> KMS_KEY_FIELD = SdkField.<KMSKey> builder(MarshallingType.SDK_POJO)
            .memberName("kmsKey").getter(getter(GetKmsEncryptionKeyResponse::kmsKey)).setter(setter(Builder::kmsKey))
            .constructor(KMSKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_FIELD));

    private final KMSKey kmsKey;

    private GetKmsEncryptionKeyResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKey = builder.kmsKey;
    }

    /**
     * <p>
     * The KMS encryption key.
     * </p>
     * 
     * @return The KMS encryption key.
     */
    public final KMSKey kmsKey() {
        return kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKmsEncryptionKeyResponse)) {
            return false;
        }
        GetKmsEncryptionKeyResponse other = (GetKmsEncryptionKeyResponse) obj;
        return Objects.equals(kmsKey(), other.kmsKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKmsEncryptionKeyResponse").add("KmsKey", kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKmsEncryptionKeyResponse, T> g) {
        return obj -> g.apply((GetKmsEncryptionKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetKmsEncryptionKeyResponse> {
        /**
         * <p>
         * The KMS encryption key.
         * </p>
         * 
         * @param kmsKey
         *        The KMS encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(KMSKey kmsKey);

        /**
         * <p>
         * The KMS encryption key.
         * </p>
         * This is a convenience method that creates an instance of the {@link KMSKey.Builder} avoiding the need to
         * create one manually via {@link KMSKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KMSKey.Builder#build()} is called immediately and its result is
         * passed to {@link #kmsKey(KMSKey)}.
         * 
         * @param kmsKey
         *        a consumer that will call methods on {@link KMSKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsKey(KMSKey)
         */
        default Builder kmsKey(Consumer<KMSKey.Builder> kmsKey) {
            return kmsKey(KMSKey.builder().applyMutation(kmsKey).build());
        }
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private KMSKey kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKmsEncryptionKeyResponse model) {
            super(model);
            kmsKey(model.kmsKey);
        }

        public final KMSKey.Builder getKmsKey() {
            return kmsKey != null ? kmsKey.toBuilder() : null;
        }

        public final void setKmsKey(KMSKey.BuilderImpl kmsKey) {
            this.kmsKey = kmsKey != null ? kmsKey.build() : null;
        }

        @Override
        public final Builder kmsKey(KMSKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        public GetKmsEncryptionKeyResponse build() {
            return new GetKmsEncryptionKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
