/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the rule used for evaluating variable values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluatedRule implements SdkPojo, Serializable, ToCopyableBuilder<EvaluatedRule.Builder, EvaluatedRule> {
    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ruleId")
            .getter(getter(EvaluatedRule::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleId").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleVersion").getter(getter(EvaluatedRule::ruleVersion)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleVersion").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(EvaluatedRule::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<String> EXPRESSION_WITH_VALUES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expressionWithValues").getter(getter(EvaluatedRule::expressionWithValues))
            .setter(setter(Builder::expressionWithValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expressionWithValues").build())
            .build();

    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("outcomes")
            .getter(getter(EvaluatedRule::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EVALUATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("evaluated").getter(getter(EvaluatedRule::evaluated)).setter(setter(Builder::evaluated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluated").build()).build();

    private static final SdkField<Boolean> MATCHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("matched").getter(getter(EvaluatedRule::matched)).setter(setter(Builder::matched))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matched").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ID_FIELD,
            RULE_VERSION_FIELD, EXPRESSION_FIELD, EXPRESSION_WITH_VALUES_FIELD, OUTCOMES_FIELD, EVALUATED_FIELD, MATCHED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ruleId;

    private final String ruleVersion;

    private final String expression;

    private final String expressionWithValues;

    private final List<String> outcomes;

    private final Boolean evaluated;

    private final Boolean matched;

    private EvaluatedRule(BuilderImpl builder) {
        this.ruleId = builder.ruleId;
        this.ruleVersion = builder.ruleVersion;
        this.expression = builder.expression;
        this.expressionWithValues = builder.expressionWithValues;
        this.outcomes = builder.outcomes;
        this.evaluated = builder.evaluated;
        this.matched = builder.matched;
    }

    /**
     * <p>
     * The rule ID.
     * </p>
     * 
     * @return The rule ID.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The rule version.
     * </p>
     * 
     * @return The rule version.
     */
    public final String ruleVersion() {
        return ruleVersion;
    }

    /**
     * <p>
     * The rule expression.
     * </p>
     * 
     * @return The rule expression.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * The rule expression value.
     * </p>
     * 
     * @return The rule expression value.
     */
    public final String expressionWithValues() {
        return expressionWithValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outcomes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule outcome.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutcomes} method.
     * </p>
     * 
     * @return The rule outcome.
     */
    public final List<String> outcomes() {
        return outcomes;
    }

    /**
     * <p>
     * Indicates whether the rule was evaluated.
     * </p>
     * 
     * @return Indicates whether the rule was evaluated.
     */
    public final Boolean evaluated() {
        return evaluated;
    }

    /**
     * <p>
     * Indicates whether the rule matched.
     * </p>
     * 
     * @return Indicates whether the rule matched.
     */
    public final Boolean matched() {
        return matched;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersion());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionWithValues());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutcomes() ? outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluated());
        hashCode = 31 * hashCode + Objects.hashCode(matched());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedRule)) {
            return false;
        }
        EvaluatedRule other = (EvaluatedRule) obj;
        return Objects.equals(ruleId(), other.ruleId()) && Objects.equals(ruleVersion(), other.ruleVersion())
                && Objects.equals(expression(), other.expression())
                && Objects.equals(expressionWithValues(), other.expressionWithValues()) && hasOutcomes() == other.hasOutcomes()
                && Objects.equals(outcomes(), other.outcomes()) && Objects.equals(evaluated(), other.evaluated())
                && Objects.equals(matched(), other.matched());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluatedRule").add("RuleId", ruleId()).add("RuleVersion", ruleVersion())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpressionWithValues", expressionWithValues() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Outcomes", hasOutcomes() ? outcomes() : null).add("Evaluated", evaluated()).add("Matched", matched())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "ruleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersion()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "expressionWithValues":
            return Optional.ofNullable(clazz.cast(expressionWithValues()));
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "evaluated":
            return Optional.ofNullable(clazz.cast(evaluated()));
        case "matched":
            return Optional.ofNullable(clazz.cast(matched()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluatedRule, T> g) {
        return obj -> g.apply((EvaluatedRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluatedRule> {
        /**
         * <p>
         * The rule ID.
         * </p>
         * 
         * @param ruleId
         *        The rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The rule version.
         * </p>
         * 
         * @param ruleVersion
         *        The rule version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * <p>
         * The rule expression.
         * </p>
         * 
         * @param expression
         *        The rule expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The rule expression value.
         * </p>
         * 
         * @param expressionWithValues
         *        The rule expression value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionWithValues(String expressionWithValues);

        /**
         * <p>
         * The rule outcome.
         * </p>
         * 
         * @param outcomes
         *        The rule outcome.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<String> outcomes);

        /**
         * <p>
         * The rule outcome.
         * </p>
         * 
         * @param outcomes
         *        The rule outcome.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(String... outcomes);

        /**
         * <p>
         * Indicates whether the rule was evaluated.
         * </p>
         * 
         * @param evaluated
         *        Indicates whether the rule was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluated(Boolean evaluated);

        /**
         * <p>
         * Indicates whether the rule matched.
         * </p>
         * 
         * @param matched
         *        Indicates whether the rule matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matched(Boolean matched);
    }

    static final class BuilderImpl implements Builder {
        private String ruleId;

        private String ruleVersion;

        private String expression;

        private String expressionWithValues;

        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();

        private Boolean evaluated;

        private Boolean matched;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatedRule model) {
            ruleId(model.ruleId);
            ruleVersion(model.ruleVersion);
            expression(model.expression);
            expressionWithValues(model.expressionWithValues);
            outcomes(model.outcomes);
            evaluated(model.evaluated);
            matched(model.matched);
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleVersion() {
            return ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getExpressionWithValues() {
            return expressionWithValues;
        }

        public final void setExpressionWithValues(String expressionWithValues) {
            this.expressionWithValues = expressionWithValues;
        }

        @Override
        public final Builder expressionWithValues(String expressionWithValues) {
            this.expressionWithValues = expressionWithValues;
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final Boolean getEvaluated() {
            return evaluated;
        }

        public final void setEvaluated(Boolean evaluated) {
            this.evaluated = evaluated;
        }

        @Override
        public final Builder evaluated(Boolean evaluated) {
            this.evaluated = evaluated;
            return this;
        }

        public final Boolean getMatched() {
            return matched;
        }

        public final void setMatched(Boolean matched) {
            this.matched = matched;
        }

        @Override
        public final Builder matched(Boolean matched) {
            this.matched = matched;
            return this;
        }

        @Override
        public EvaluatedRule build() {
            return new EvaluatedRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
