/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRulesResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetRulesResponse.Builder, GetRulesResponse> {
    private static final SdkField<List<RuleDetail>> RULE_DETAILS_FIELD = SdkField
            .<List<RuleDetail>> builder(MarshallingType.LIST)
            .memberName("ruleDetails")
            .getter(getter(GetRulesResponse::ruleDetails))
            .setter(setter(Builder::ruleDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RuleDetail> ruleDetails;

    private final String nextToken;

    private GetRulesResponse(BuilderImpl builder) {
        super(builder);
        this.ruleDetails = builder.ruleDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleDetails() {
        return ruleDetails != null && !(ruleDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the requested rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleDetails} method.
     * </p>
     * 
     * @return The details of the requested rule.
     */
    public final List<RuleDetail> ruleDetails() {
        return ruleDetails;
    }

    /**
     * <p>
     * The next page token to be used in subsequent requests.
     * </p>
     * 
     * @return The next page token to be used in subsequent requests.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleDetails() ? ruleDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRulesResponse)) {
            return false;
        }
        GetRulesResponse other = (GetRulesResponse) obj;
        return hasRuleDetails() == other.hasRuleDetails() && Objects.equals(ruleDetails(), other.ruleDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRulesResponse").add("RuleDetails", hasRuleDetails() ? ruleDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleDetails":
            return Optional.ofNullable(clazz.cast(ruleDetails()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRulesResponse, T> g) {
        return obj -> g.apply((GetRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRulesResponse> {
        /**
         * <p>
         * The details of the requested rule.
         * </p>
         * 
         * @param ruleDetails
         *        The details of the requested rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDetails(Collection<RuleDetail> ruleDetails);

        /**
         * <p>
         * The details of the requested rule.
         * </p>
         * 
         * @param ruleDetails
         *        The details of the requested rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDetails(RuleDetail... ruleDetails);

        /**
         * <p>
         * The details of the requested rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.RuleDetail.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.frauddetector.model.RuleDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.RuleDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleDetails(List<RuleDetail>)}.
         * 
         * @param ruleDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.RuleDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleDetails(java.util.Collection<RuleDetail>)
         */
        Builder ruleDetails(Consumer<RuleDetail.Builder>... ruleDetails);

        /**
         * <p>
         * The next page token to be used in subsequent requests.
         * </p>
         * 
         * @param nextToken
         *        The next page token to be used in subsequent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<RuleDetail> ruleDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRulesResponse model) {
            super(model);
            ruleDetails(model.ruleDetails);
            nextToken(model.nextToken);
        }

        public final List<RuleDetail.Builder> getRuleDetails() {
            List<RuleDetail.Builder> result = RuleDetailListCopier.copyToBuilder(this.ruleDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleDetails(Collection<RuleDetail.BuilderImpl> ruleDetails) {
            this.ruleDetails = RuleDetailListCopier.copyFromBuilder(ruleDetails);
        }

        @Override
        public final Builder ruleDetails(Collection<RuleDetail> ruleDetails) {
            this.ruleDetails = RuleDetailListCopier.copy(ruleDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDetails(RuleDetail... ruleDetails) {
            ruleDetails(Arrays.asList(ruleDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDetails(Consumer<RuleDetail.Builder>... ruleDetails) {
            ruleDetails(Stream.of(ruleDetails).map(c -> RuleDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetRulesResponse build() {
            return new GetRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
