/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEventRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<DeleteEventRequest.Builder, DeleteEventRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(DeleteEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(DeleteEventRequest::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<Boolean> DELETE_AUDIT_HISTORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteAuditHistory").getter(getter(DeleteEventRequest::deleteAuditHistory))
            .setter(setter(Builder::deleteAuditHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteAuditHistory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, DELETE_AUDIT_HISTORY_FIELD));

    private final String eventId;

    private final String eventTypeName;

    private final Boolean deleteAuditHistory;

    private DeleteEventRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.deleteAuditHistory = builder.deleteAuditHistory;
    }

    /**
     * <p>
     * The ID of the event to delete.
     * </p>
     * 
     * @return The ID of the event to delete.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @return The name of the event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
     * </p>
     * 
     * @return Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>
     *         ,
     */
    public final Boolean deleteAuditHistory() {
        return deleteAuditHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAuditHistory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventRequest)) {
            return false;
        }
        DeleteEventRequest other = (DeleteEventRequest) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(deleteAuditHistory(), other.deleteAuditHistory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEventRequest").add("EventId", eventId()).add("EventTypeName", eventTypeName())
                .add("DeleteAuditHistory", deleteAuditHistory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "deleteAuditHistory":
            return Optional.ofNullable(clazz.cast(deleteAuditHistory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEventRequest, T> g) {
        return obj -> g.apply((DeleteEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEventRequest> {
        /**
         * <p>
         * The ID of the event to delete.
         * </p>
         * 
         * @param eventId
         *        The ID of the event to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The name of the event type.
         * </p>
         * 
         * @param eventTypeName
         *        The name of the event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * Specifies whether or not to delete any predictions associated with the event. If set to <code>True</code>,
         * </p>
         * 
         * @param deleteAuditHistory
         *        Specifies whether or not to delete any predictions associated with the event. If set to
         *        <code>True</code>,
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAuditHistory(Boolean deleteAuditHistory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private Boolean deleteAuditHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventRequest model) {
            super(model);
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            deleteAuditHistory(model.deleteAuditHistory);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final Boolean getDeleteAuditHistory() {
            return deleteAuditHistory;
        }

        public final void setDeleteAuditHistory(Boolean deleteAuditHistory) {
            this.deleteAuditHistory = deleteAuditHistory;
        }

        @Override
        public final Builder deleteAuditHistory(Boolean deleteAuditHistory) {
            this.deleteAuditHistory = deleteAuditHistory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEventRequest build() {
            return new DeleteEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
