/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log odds metric details.
 * </p>
 * <p>
 * Account Takeover Insights (ATI) model uses event variables from the login data you provide to continuously calculate
 * a set of variables (aggregated variables) based on historical events. For example, your ATI model might calculate the
 * number of times an user has logged in using the same IP address. In this case, event variables used to derive the
 * aggregated variables are <code>IP address</code> and <code>user</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatedLogOddsMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatedLogOddsMetric.Builder, AggregatedLogOddsMetric> {
    private static final SdkField<List<String>> VARIABLE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("variableNames")
            .getter(getter(AggregatedLogOddsMetric::variableNames))
            .setter(setter(Builder::variableNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> AGGREGATED_VARIABLES_IMPORTANCE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("aggregatedVariablesImportance")
            .getter(getter(AggregatedLogOddsMetric::aggregatedVariablesImportance))
            .setter(setter(Builder::aggregatedVariablesImportance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedVariablesImportance")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_NAMES_FIELD,
            AGGREGATED_VARIABLES_IMPORTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> variableNames;

    private final Float aggregatedVariablesImportance;

    private AggregatedLogOddsMetric(BuilderImpl builder) {
        this.variableNames = builder.variableNames;
        this.aggregatedVariablesImportance = builder.aggregatedVariablesImportance;
    }

    /**
     * For responses, this returns true if the service returned a value for the VariableNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVariableNames() {
        return variableNames != null && !(variableNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of all the variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariableNames} method.
     * </p>
     * 
     * @return The names of all the variables.
     */
    public final List<String> variableNames() {
        return variableNames;
    }

    /**
     * <p>
     * The relative importance of the variables in the list to the other event variable.
     * </p>
     * 
     * @return The relative importance of the variables in the list to the other event variable.
     */
    public final Float aggregatedVariablesImportance() {
        return aggregatedVariablesImportance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVariableNames() ? variableNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedVariablesImportance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedLogOddsMetric)) {
            return false;
        }
        AggregatedLogOddsMetric other = (AggregatedLogOddsMetric) obj;
        return hasVariableNames() == other.hasVariableNames() && Objects.equals(variableNames(), other.variableNames())
                && Objects.equals(aggregatedVariablesImportance(), other.aggregatedVariablesImportance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregatedLogOddsMetric").add("VariableNames", hasVariableNames() ? variableNames() : null)
                .add("AggregatedVariablesImportance", aggregatedVariablesImportance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variableNames":
            return Optional.ofNullable(clazz.cast(variableNames()));
        case "aggregatedVariablesImportance":
            return Optional.ofNullable(clazz.cast(aggregatedVariablesImportance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedLogOddsMetric, T> g) {
        return obj -> g.apply((AggregatedLogOddsMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatedLogOddsMetric> {
        /**
         * <p>
         * The names of all the variables.
         * </p>
         * 
         * @param variableNames
         *        The names of all the variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableNames(Collection<String> variableNames);

        /**
         * <p>
         * The names of all the variables.
         * </p>
         * 
         * @param variableNames
         *        The names of all the variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variableNames(String... variableNames);

        /**
         * <p>
         * The relative importance of the variables in the list to the other event variable.
         * </p>
         * 
         * @param aggregatedVariablesImportance
         *        The relative importance of the variables in the list to the other event variable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedVariablesImportance(Float aggregatedVariablesImportance);
    }

    static final class BuilderImpl implements Builder {
        private List<String> variableNames = DefaultSdkAutoConstructList.getInstance();

        private Float aggregatedVariablesImportance;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedLogOddsMetric model) {
            variableNames(model.variableNames);
            aggregatedVariablesImportance(model.aggregatedVariablesImportance);
        }

        public final Collection<String> getVariableNames() {
            if (variableNames instanceof SdkAutoConstructList) {
                return null;
            }
            return variableNames;
        }

        public final void setVariableNames(Collection<String> variableNames) {
            this.variableNames = ListOfStringsCopier.copy(variableNames);
        }

        @Override
        public final Builder variableNames(Collection<String> variableNames) {
            this.variableNames = ListOfStringsCopier.copy(variableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variableNames(String... variableNames) {
            variableNames(Arrays.asList(variableNames));
            return this;
        }

        public final Float getAggregatedVariablesImportance() {
            return aggregatedVariablesImportance;
        }

        public final void setAggregatedVariablesImportance(Float aggregatedVariablesImportance) {
            this.aggregatedVariablesImportance = aggregatedVariablesImportance;
        }

        @Override
        public final Builder aggregatedVariablesImportance(Float aggregatedVariablesImportance) {
            this.aggregatedVariablesImportance = aggregatedVariablesImportance;
            return this;
        }

        @Override
        public AggregatedLogOddsMetric build() {
            return new AggregatedLogOddsMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
