/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendEventRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<SendEventRequest.Builder, SendEventRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(SendEventRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(SendEventRequest::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTimestamp").getter(getter(SendEventRequest::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<Map<String, String>> EVENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("eventVariables")
            .getter(getter(SendEventRequest::eventVariables))
            .setter(setter(Builder::eventVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ASSIGNED_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assignedLabel").getter(getter(SendEventRequest::assignedLabel)).setter(setter(Builder::assignedLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedLabel").build()).build();

    private static final SdkField<String> LABEL_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("labelTimestamp").getter(getter(SendEventRequest::labelTimestamp))
            .setter(setter(Builder::labelTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelTimestamp").build()).build();

    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("entities")
            .getter(getter(SendEventRequest::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, EVENT_TIMESTAMP_FIELD, EVENT_VARIABLES_FIELD, ASSIGNED_LABEL_FIELD, LABEL_TIMESTAMP_FIELD,
            ENTITIES_FIELD));

    private final String eventId;

    private final String eventTypeName;

    private final String eventTimestamp;

    private final Map<String, String> eventVariables;

    private final String assignedLabel;

    private final String labelTimestamp;

    private final List<Entity> entities;

    private SendEventRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.eventTimestamp = builder.eventTimestamp;
        this.eventVariables = builder.eventVariables;
        this.assignedLabel = builder.assignedLabel;
        this.labelTimestamp = builder.labelTimestamp;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * The event ID to upload.
     * </p>
     * 
     * @return The event ID to upload.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type name of the event.
     * </p>
     * 
     * @return The event type name of the event.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using ISO
     * 8601 standard in UTC.
     * </p>
     * 
     * @return The timestamp that defines when the event under evaluation occurred. The timestamp must be specified
     *         using ISO 8601 standard in UTC.
     */
    public final String eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventVariables() {
        return eventVariables != null && !(eventVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
     * corresponding values for the event you are sending for evaluation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventVariables} method.
     * </p>
     * 
     * @return Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and
     *         their corresponding values for the event you are sending for evaluation.
     */
    public final Map<String, String> eventVariables() {
        return eventVariables;
    }

    /**
     * <p>
     * The label to associate with the event. Required if specifying <code>labelTimestamp</code>.
     * </p>
     * 
     * @return The label to associate with the event. Required if specifying <code>labelTimestamp</code>.
     */
    public final String assignedLabel() {
        return assignedLabel;
    }

    /**
     * <p>
     * The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.
     * </p>
     * 
     * @return The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.
     */
    public final String labelTimestamp() {
        return labelTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return An array of entities.
     */
    public final List<Entity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventVariables() ? eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assignedLabel());
        hashCode = 31 * hashCode + Objects.hashCode(labelTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEventRequest)) {
            return false;
        }
        SendEventRequest other = (SendEventRequest) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && hasEventVariables() == other.hasEventVariables()
                && Objects.equals(eventVariables(), other.eventVariables())
                && Objects.equals(assignedLabel(), other.assignedLabel())
                && Objects.equals(labelTimestamp(), other.labelTimestamp()) && hasEntities() == other.hasEntities()
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendEventRequest").add("EventId", eventId()).add("EventTypeName", eventTypeName())
                .add("EventTimestamp", eventTimestamp())
                .add("EventVariables", eventVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AssignedLabel", assignedLabel()).add("LabelTimestamp", labelTimestamp())
                .add("Entities", entities() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "eventVariables":
            return Optional.ofNullable(clazz.cast(eventVariables()));
        case "assignedLabel":
            return Optional.ofNullable(clazz.cast(assignedLabel()));
        case "labelTimestamp":
            return Optional.ofNullable(clazz.cast(labelTimestamp()));
        case "entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendEventRequest, T> g) {
        return obj -> g.apply((SendEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendEventRequest> {
        /**
         * <p>
         * The event ID to upload.
         * </p>
         * 
         * @param eventId
         *        The event ID to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type name of the event.
         * </p>
         * 
         * @param eventTypeName
         *        The event type name of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The timestamp that defines when the event under evaluation occurred. The timestamp must be specified using
         * ISO 8601 standard in UTC.
         * </p>
         * 
         * @param eventTimestamp
         *        The timestamp that defines when the event under evaluation occurred. The timestamp must be specified
         *        using ISO 8601 standard in UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(String eventTimestamp);

        /**
         * <p>
         * Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements and their
         * corresponding values for the event you are sending for evaluation.
         * </p>
         * 
         * @param eventVariables
         *        Names of the event type's variables you defined in Amazon Fraud Detector to represent data elements
         *        and their corresponding values for the event you are sending for evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventVariables(Map<String, String> eventVariables);

        /**
         * <p>
         * The label to associate with the event. Required if specifying <code>labelTimestamp</code>.
         * </p>
         * 
         * @param assignedLabel
         *        The label to associate with the event. Required if specifying <code>labelTimestamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedLabel(String assignedLabel);

        /**
         * <p>
         * The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.
         * </p>
         * 
         * @param labelTimestamp
         *        The timestamp associated with the label. Required if specifying <code>assignedLabel</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelTimestamp(String labelTimestamp);

        /**
         * <p>
         * An array of entities.
         * </p>
         * 
         * @param entities
         *        An array of entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<Entity> entities);

        /**
         * <p>
         * An array of entities.
         * </p>
         * 
         * @param entities
         *        An array of entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Entity... entities);

        /**
         * <p>
         * An array of entities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.frauddetector.model.Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder#build()} is called immediately and
         * its result is passed to {@link #entities(List<Entity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<Entity>)
         */
        Builder entities(Consumer<Entity.Builder>... entities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private String eventTimestamp;

        private Map<String, String> eventVariables = DefaultSdkAutoConstructMap.getInstance();

        private String assignedLabel;

        private String labelTimestamp;

        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendEventRequest model) {
            super(model);
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            eventTimestamp(model.eventTimestamp);
            eventVariables(model.eventVariables);
            assignedLabel(model.assignedLabel);
            labelTimestamp(model.labelTimestamp);
            entities(model.entities);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final Map<String, String> getEventVariables() {
            if (eventVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return eventVariables;
        }

        public final void setEventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventVariableMapCopier.copy(eventVariables);
            return this;
        }

        public final String getAssignedLabel() {
            return assignedLabel;
        }

        public final void setAssignedLabel(String assignedLabel) {
            this.assignedLabel = assignedLabel;
        }

        @Override
        public final Builder assignedLabel(String assignedLabel) {
            this.assignedLabel = assignedLabel;
            return this;
        }

        public final String getLabelTimestamp() {
            return labelTimestamp;
        }

        public final void setLabelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
        }

        @Override
        public final Builder labelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = _listOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = _listOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = _listOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> Entity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEventRequest build() {
            return new SendEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
