/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Online Fraud Insights (OFI) model training metric details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OFITrainingMetricsValue implements SdkPojo, Serializable,
        ToCopyableBuilder<OFITrainingMetricsValue.Builder, OFITrainingMetricsValue> {
    private static final SdkField<List<OFIMetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField
            .<List<OFIMetricDataPoint>> builder(MarshallingType.LIST)
            .memberName("metricDataPoints")
            .getter(getter(OFITrainingMetricsValue::metricDataPoints))
            .setter(setter(Builder::metricDataPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OFIMetricDataPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(OFIMetricDataPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OFIModelPerformance> MODEL_PERFORMANCE_FIELD = SdkField
            .<OFIModelPerformance> builder(MarshallingType.SDK_POJO).memberName("modelPerformance")
            .getter(getter(OFITrainingMetricsValue::modelPerformance)).setter(setter(Builder::modelPerformance))
            .constructor(OFIModelPerformance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelPerformance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_POINTS_FIELD,
            MODEL_PERFORMANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<OFIMetricDataPoint> metricDataPoints;

    private final OFIModelPerformance modelPerformance;

    private OFITrainingMetricsValue(BuilderImpl builder) {
        this.metricDataPoints = builder.metricDataPoints;
        this.modelPerformance = builder.modelPerformance;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDataPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDataPoints() {
        return metricDataPoints != null && !(metricDataPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The model's performance metrics data points.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDataPoints} method.
     * </p>
     * 
     * @return The model's performance metrics data points.
     */
    public final List<OFIMetricDataPoint> metricDataPoints() {
        return metricDataPoints;
    }

    /**
     * <p>
     * The model's overall performance score.
     * </p>
     * 
     * @return The model's overall performance score.
     */
    public final OFIModelPerformance modelPerformance() {
        return modelPerformance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDataPoints() ? metricDataPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelPerformance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFITrainingMetricsValue)) {
            return false;
        }
        OFITrainingMetricsValue other = (OFITrainingMetricsValue) obj;
        return hasMetricDataPoints() == other.hasMetricDataPoints()
                && Objects.equals(metricDataPoints(), other.metricDataPoints())
                && Objects.equals(modelPerformance(), other.modelPerformance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OFITrainingMetricsValue")
                .add("MetricDataPoints", hasMetricDataPoints() ? metricDataPoints() : null)
                .add("ModelPerformance", modelPerformance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricDataPoints":
            return Optional.ofNullable(clazz.cast(metricDataPoints()));
        case "modelPerformance":
            return Optional.ofNullable(clazz.cast(modelPerformance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OFITrainingMetricsValue, T> g) {
        return obj -> g.apply((OFITrainingMetricsValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OFITrainingMetricsValue> {
        /**
         * <p>
         * The model's performance metrics data points.
         * </p>
         * 
         * @param metricDataPoints
         *        The model's performance metrics data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataPoints(Collection<OFIMetricDataPoint> metricDataPoints);

        /**
         * <p>
         * The model's performance metrics data points.
         * </p>
         * 
         * @param metricDataPoints
         *        The model's performance metrics data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDataPoints(OFIMetricDataPoint... metricDataPoints);

        /**
         * <p>
         * The model's performance metrics data points.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPoint.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPoint.Builder#build()} is called
         * immediately and its result is passed to {@link #metricDataPoints(List<OFIMetricDataPoint>)}.
         * 
         * @param metricDataPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.frauddetector.model.OFIMetricDataPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDataPoints(java.util.Collection<OFIMetricDataPoint>)
         */
        Builder metricDataPoints(Consumer<OFIMetricDataPoint.Builder>... metricDataPoints);

        /**
         * <p>
         * The model's overall performance score.
         * </p>
         * 
         * @param modelPerformance
         *        The model's overall performance score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPerformance(OFIModelPerformance modelPerformance);

        /**
         * <p>
         * The model's overall performance score.
         * </p>
         * This is a convenience method that creates an instance of the {@link OFIModelPerformance.Builder} avoiding the
         * need to create one manually via {@link OFIModelPerformance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OFIModelPerformance.Builder#build()} is called immediately and
         * its result is passed to {@link #modelPerformance(OFIModelPerformance)}.
         * 
         * @param modelPerformance
         *        a consumer that will call methods on {@link OFIModelPerformance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPerformance(OFIModelPerformance)
         */
        default Builder modelPerformance(Consumer<OFIModelPerformance.Builder> modelPerformance) {
            return modelPerformance(OFIModelPerformance.builder().applyMutation(modelPerformance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<OFIMetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();

        private OFIModelPerformance modelPerformance;

        private BuilderImpl() {
        }

        private BuilderImpl(OFITrainingMetricsValue model) {
            metricDataPoints(model.metricDataPoints);
            modelPerformance(model.modelPerformance);
        }

        public final List<OFIMetricDataPoint.Builder> getMetricDataPoints() {
            List<OFIMetricDataPoint.Builder> result = OFIMetricDataPointsListCopier.copyToBuilder(this.metricDataPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDataPoints(Collection<OFIMetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = OFIMetricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        @Override
        public final Builder metricDataPoints(Collection<OFIMetricDataPoint> metricDataPoints) {
            this.metricDataPoints = OFIMetricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(OFIMetricDataPoint... metricDataPoints) {
            metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<OFIMetricDataPoint.Builder>... metricDataPoints) {
            metricDataPoints(Stream.of(metricDataPoints).map(c -> OFIMetricDataPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final OFIModelPerformance.Builder getModelPerformance() {
            return modelPerformance != null ? modelPerformance.toBuilder() : null;
        }

        public final void setModelPerformance(OFIModelPerformance.BuilderImpl modelPerformance) {
            this.modelPerformance = modelPerformance != null ? modelPerformance.build() : null;
        }

        @Override
        public final Builder modelPerformance(OFIModelPerformance modelPerformance) {
            this.modelPerformance = modelPerformance;
            return this;
        }

        @Override
        public OFITrainingMetricsValue build() {
            return new OFITrainingMetricsValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
