/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DestinationType {
    IPV4("IPV4"),
    IPV6("IPV6"),
    PREFIX_LIST("PREFIX_LIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DestinationType> VALUE_MAP;
    private final String value;

    private DestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DestinationType> knownValues() {
        EnumSet<DestinationType> knownValues = EnumSet.allOf(DestinationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DestinationType.class, DestinationType::toString);
    }
}

