/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.fms.DefaultFmsAsyncClient;
import software.amazon.awssdk.services.fms.DefaultFmsBaseClientBuilder;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.FmsAsyncClientBuilder;
import software.amazon.awssdk.services.fms.FmsServiceClientConfiguration;
import software.amazon.awssdk.services.fms.endpoints.FmsEndpointProvider;

@SdkInternalApi
final class DefaultFmsAsyncClientBuilder
extends DefaultFmsBaseClientBuilder<FmsAsyncClientBuilder, FmsAsyncClient>
implements FmsAsyncClientBuilder {
    DefaultFmsAsyncClientBuilder() {
    }

    @Override
    public DefaultFmsAsyncClientBuilder endpointProvider(FmsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FmsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultFmsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        FmsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFmsAsyncClient client = new DefaultFmsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FmsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FmsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

