/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the policy types that the specified Firewall Manager administrator can manage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyTypeScope implements SdkPojo, Serializable, ToCopyableBuilder<PolicyTypeScope.Builder, PolicyTypeScope> {
    private static final SdkField<List<String>> POLICY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PolicyTypes")
            .getter(getter(PolicyTypeScope::policyTypesAsStrings))
            .setter(setter(Builder::policyTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALL_POLICY_TYPES_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllPolicyTypesEnabled").getter(getter(PolicyTypeScope::allPolicyTypesEnabled))
            .setter(setter(Builder::allPolicyTypesEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllPolicyTypesEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPES_FIELD,
            ALL_POLICY_TYPES_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> policyTypes;

    private final Boolean allPolicyTypesEnabled;

    private PolicyTypeScope(BuilderImpl builder) {
        this.policyTypes = builder.policyTypes;
        this.allPolicyTypesEnabled = builder.allPolicyTypesEnabled;
    }

    /**
     * <p>
     * The list of policy types that the specified Firewall Manager administrator can manage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyTypes} method.
     * </p>
     * 
     * @return The list of policy types that the specified Firewall Manager administrator can manage.
     */
    public final List<SecurityServiceType> policyTypes() {
        return SecurityServiceTypeListCopier.copyStringToEnum(policyTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPolicyTypes() {
        return policyTypes != null && !(policyTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of policy types that the specified Firewall Manager administrator can manage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyTypes} method.
     * </p>
     * 
     * @return The list of policy types that the specified Firewall Manager administrator can manage.
     */
    public final List<String> policyTypesAsStrings() {
        return policyTypes;
    }

    /**
     * <p>
     * Allows the specified Firewall Manager administrator to manage all Firewall Manager policy types, except for
     * third-party policy types. Third-party policy types can only be managed by the Firewall Manager default
     * administrator.
     * </p>
     * 
     * @return Allows the specified Firewall Manager administrator to manage all Firewall Manager policy types, except
     *         for third-party policy types. Third-party policy types can only be managed by the Firewall Manager
     *         default administrator.
     */
    public final Boolean allPolicyTypesEnabled() {
        return allPolicyTypesEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyTypes() ? policyTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allPolicyTypesEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeScope)) {
            return false;
        }
        PolicyTypeScope other = (PolicyTypeScope) obj;
        return hasPolicyTypes() == other.hasPolicyTypes() && Objects.equals(policyTypesAsStrings(), other.policyTypesAsStrings())
                && Objects.equals(allPolicyTypesEnabled(), other.allPolicyTypesEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyTypeScope").add("PolicyTypes", hasPolicyTypes() ? policyTypesAsStrings() : null)
                .add("AllPolicyTypesEnabled", allPolicyTypesEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyTypes":
            return Optional.ofNullable(clazz.cast(policyTypesAsStrings()));
        case "AllPolicyTypesEnabled":
            return Optional.ofNullable(clazz.cast(allPolicyTypesEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyTypeScope, T> g) {
        return obj -> g.apply((PolicyTypeScope) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyTypeScope> {
        /**
         * <p>
         * The list of policy types that the specified Firewall Manager administrator can manage.
         * </p>
         * 
         * @param policyTypes
         *        The list of policy types that the specified Firewall Manager administrator can manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypesWithStrings(Collection<String> policyTypes);

        /**
         * <p>
         * The list of policy types that the specified Firewall Manager administrator can manage.
         * </p>
         * 
         * @param policyTypes
         *        The list of policy types that the specified Firewall Manager administrator can manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypesWithStrings(String... policyTypes);

        /**
         * <p>
         * The list of policy types that the specified Firewall Manager administrator can manage.
         * </p>
         * 
         * @param policyTypes
         *        The list of policy types that the specified Firewall Manager administrator can manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(Collection<SecurityServiceType> policyTypes);

        /**
         * <p>
         * The list of policy types that the specified Firewall Manager administrator can manage.
         * </p>
         * 
         * @param policyTypes
         *        The list of policy types that the specified Firewall Manager administrator can manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(SecurityServiceType... policyTypes);

        /**
         * <p>
         * Allows the specified Firewall Manager administrator to manage all Firewall Manager policy types, except for
         * third-party policy types. Third-party policy types can only be managed by the Firewall Manager default
         * administrator.
         * </p>
         * 
         * @param allPolicyTypesEnabled
         *        Allows the specified Firewall Manager administrator to manage all Firewall Manager policy types,
         *        except for third-party policy types. Third-party policy types can only be managed by the Firewall
         *        Manager default administrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allPolicyTypesEnabled(Boolean allPolicyTypesEnabled);
    }

    static final class BuilderImpl implements Builder {
        private List<String> policyTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean allPolicyTypesEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeScope model) {
            policyTypesWithStrings(model.policyTypes);
            allPolicyTypesEnabled(model.allPolicyTypesEnabled);
        }

        public final Collection<String> getPolicyTypes() {
            if (policyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return policyTypes;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copy(policyTypes);
        }

        @Override
        public final Builder policyTypesWithStrings(Collection<String> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypesWithStrings(String... policyTypes) {
            policyTypesWithStrings(Arrays.asList(policyTypes));
            return this;
        }

        @Override
        public final Builder policyTypes(Collection<SecurityServiceType> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copyEnumToString(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(SecurityServiceType... policyTypes) {
            policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final Boolean getAllPolicyTypesEnabled() {
            return allPolicyTypesEnabled;
        }

        public final void setAllPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
            this.allPolicyTypesEnabled = allPolicyTypesEnabled;
        }

        @Override
        public final Builder allPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
            this.allPolicyTypesEnabled = allPolicyTypesEnabled;
            return this;
        }

        @Override
        public PolicyTypeScope build() {
            return new PolicyTypeScope(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
