/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetThirdPartyFirewallAssociationStatusResponse extends FmsResponse implements
        ToCopyableBuilder<GetThirdPartyFirewallAssociationStatusResponse.Builder, GetThirdPartyFirewallAssociationStatusResponse> {
    private static final SdkField<String> THIRD_PARTY_FIREWALL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThirdPartyFirewallStatus")
            .getter(getter(GetThirdPartyFirewallAssociationStatusResponse::thirdPartyFirewallStatusAsString))
            .setter(setter(Builder::thirdPartyFirewallStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallStatus").build())
            .build();

    private static final SdkField<String> MARKETPLACE_ONBOARDING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MarketplaceOnboardingStatus")
            .getter(getter(GetThirdPartyFirewallAssociationStatusResponse::marketplaceOnboardingStatusAsString))
            .setter(setter(Builder::marketplaceOnboardingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceOnboardingStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            THIRD_PARTY_FIREWALL_STATUS_FIELD, MARKETPLACE_ONBOARDING_STATUS_FIELD));

    private final String thirdPartyFirewallStatus;

    private final String marketplaceOnboardingStatus;

    private GetThirdPartyFirewallAssociationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.thirdPartyFirewallStatus = builder.thirdPartyFirewallStatus;
        this.marketplaceOnboardingStatus = builder.marketplaceOnboardingStatus;
    }

    /**
     * <p>
     * The current status for setting a Firewall Manager policy administrators account as an administrator of the
     * third-party firewall tenant.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewallStatus} will return {@link ThirdPartyFirewallAssociationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thirdPartyFirewallStatusAsString}.
     * </p>
     * 
     * @return The current status for setting a Firewall Manager policy administrators account as an administrator of
     *         the third-party firewall tenant.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant
     *         administrator.
     *         </p>
     *         </li>
     * @see ThirdPartyFirewallAssociationStatus
     */
    public final ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus() {
        return ThirdPartyFirewallAssociationStatus.fromValue(thirdPartyFirewallStatus);
    }

    /**
     * <p>
     * The current status for setting a Firewall Manager policy administrators account as an administrator of the
     * third-party firewall tenant.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
     * administrator.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant administrator.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thirdPartyFirewallStatus} will return {@link ThirdPartyFirewallAssociationStatus#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thirdPartyFirewallStatusAsString}.
     * </p>
     * 
     * @return The current status for setting a Firewall Manager policy administrators account as an administrator of
     *         the third-party firewall tenant.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
     *         administrator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant
     *         administrator.
     *         </p>
     *         </li>
     * @see ThirdPartyFirewallAssociationStatus
     */
    public final String thirdPartyFirewallStatusAsString() {
        return thirdPartyFirewallStatus;
    }

    /**
     * <p>
     * The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the third-party
     * firewall service in the Amazon Web Services Marketplace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to the
     * third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active subscription.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the third-party
     * firewall service in the Amazon Web Services Marketplace.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #marketplaceOnboardingStatus} will return
     * {@link MarketplaceSubscriptionOnboardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketplaceOnboardingStatusAsString}.
     * </p>
     * 
     * @return The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the
     *         third-party firewall service in the Amazon Web Services Marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to
     *         the third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active
     *         subscription.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
     *         third-party firewall service in the Amazon Web Services Marketplace.
     *         </p>
     *         </li>
     * @see MarketplaceSubscriptionOnboardingStatus
     */
    public final MarketplaceSubscriptionOnboardingStatus marketplaceOnboardingStatus() {
        return MarketplaceSubscriptionOnboardingStatus.fromValue(marketplaceOnboardingStatus);
    }

    /**
     * <p>
     * The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the third-party
     * firewall service in the Amazon Web Services Marketplace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to the
     * third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active subscription.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the third-party
     * firewall service in the Amazon Web Services Marketplace.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #marketplaceOnboardingStatus} will return
     * {@link MarketplaceSubscriptionOnboardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #marketplaceOnboardingStatusAsString}.
     * </p>
     * 
     * @return The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the
     *         third-party firewall service in the Amazon Web Services Marketplace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to
     *         the third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active
     *         subscription.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
     *         third-party firewall service in the Amazon Web Services Marketplace.
     *         </p>
     *         </li>
     * @see MarketplaceSubscriptionOnboardingStatus
     */
    public final String marketplaceOnboardingStatusAsString() {
        return marketplaceOnboardingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thirdPartyFirewallStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceOnboardingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetThirdPartyFirewallAssociationStatusResponse)) {
            return false;
        }
        GetThirdPartyFirewallAssociationStatusResponse other = (GetThirdPartyFirewallAssociationStatusResponse) obj;
        return Objects.equals(thirdPartyFirewallStatusAsString(), other.thirdPartyFirewallStatusAsString())
                && Objects.equals(marketplaceOnboardingStatusAsString(), other.marketplaceOnboardingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetThirdPartyFirewallAssociationStatusResponse")
                .add("ThirdPartyFirewallStatus", thirdPartyFirewallStatusAsString())
                .add("MarketplaceOnboardingStatus", marketplaceOnboardingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThirdPartyFirewallStatus":
            return Optional.ofNullable(clazz.cast(thirdPartyFirewallStatusAsString()));
        case "MarketplaceOnboardingStatus":
            return Optional.ofNullable(clazz.cast(marketplaceOnboardingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetThirdPartyFirewallAssociationStatusResponse, T> g) {
        return obj -> g.apply((GetThirdPartyFirewallAssociationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetThirdPartyFirewallAssociationStatusResponse> {
        /**
         * <p>
         * The current status for setting a Firewall Manager policy administrators account as an administrator of the
         * third-party firewall tenant.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thirdPartyFirewallStatus
         *        The current status for setting a Firewall Manager policy administrators account as an administrator of
         *        the third-party firewall tenant.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a
         *        tenant administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant
         *        administrator.
         *        </p>
         *        </li>
         * @see ThirdPartyFirewallAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewallAssociationStatus
         */
        Builder thirdPartyFirewallStatus(String thirdPartyFirewallStatus);

        /**
         * <p>
         * The current status for setting a Firewall Manager policy administrators account as an administrator of the
         * third-party firewall tenant.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a tenant
         * administrator.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant administrator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thirdPartyFirewallStatus
         *        The current status for setting a Firewall Manager policy administrators account as an administrator of
         *        the third-party firewall tenant.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONBOARDING</code> - The Firewall Manager policy administrator is being designated as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ONBOARD_COMPLETE</code> - The Firewall Manager policy administrator is designated as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARDING</code> - The Firewall Manager policy administrator is being removed as a tenant
         *        administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFFBOARD_COMPLETE</code> - The Firewall Manager policy administrator has been removed as a
         *        tenant administrator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_EXIST</code> - The Firewall Manager policy administrator doesn't exist as a tenant
         *        administrator.
         *        </p>
         *        </li>
         * @see ThirdPartyFirewallAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThirdPartyFirewallAssociationStatus
         */
        Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus);

        /**
         * <p>
         * The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the third-party
         * firewall service in the Amazon Web Services Marketplace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to the
         * third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active
         * subscription.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
         * third-party firewall service in the Amazon Web Services Marketplace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param marketplaceOnboardingStatus
         *        The status for subscribing to the third-party firewall vendor in the Amazon Web Services
         *        Marketplace.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the
         *        third-party firewall service in the Amazon Web Services Marketplace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing
         *        to the third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an
         *        active subscription.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
         *        third-party firewall service in the Amazon Web Services Marketplace.
         *        </p>
         *        </li>
         * @see MarketplaceSubscriptionOnboardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketplaceSubscriptionOnboardingStatus
         */
        Builder marketplaceOnboardingStatus(String marketplaceOnboardingStatus);

        /**
         * <p>
         * The status for subscribing to the third-party firewall vendor in the Amazon Web Services Marketplace.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the third-party
         * firewall service in the Amazon Web Services Marketplace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing to the
         * third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an active
         * subscription.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
         * third-party firewall service in the Amazon Web Services Marketplace.
         * </p>
         * </li>
         * </ul>
         * 
         * @param marketplaceOnboardingStatus
         *        The status for subscribing to the third-party firewall vendor in the Amazon Web Services
         *        Marketplace.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NO_SUBSCRIPTION</code> - The Firewall Manager policy administrator isn't subscribed to the
         *        third-party firewall service in the Amazon Web Services Marketplace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_COMPLETE</code> - The Firewall Manager policy administrator is in the process of subscribing
         *        to the third-party firewall service in the Amazon Web Services Marketplace, but doesn't yet have an
         *        active subscription.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - The Firewall Manager policy administrator has an active subscription to the
         *        third-party firewall service in the Amazon Web Services Marketplace.
         *        </p>
         *        </li>
         * @see MarketplaceSubscriptionOnboardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketplaceSubscriptionOnboardingStatus
         */
        Builder marketplaceOnboardingStatus(MarketplaceSubscriptionOnboardingStatus marketplaceOnboardingStatus);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private String thirdPartyFirewallStatus;

        private String marketplaceOnboardingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetThirdPartyFirewallAssociationStatusResponse model) {
            super(model);
            thirdPartyFirewallStatus(model.thirdPartyFirewallStatus);
            marketplaceOnboardingStatus(model.marketplaceOnboardingStatus);
        }

        public final String getThirdPartyFirewallStatus() {
            return thirdPartyFirewallStatus;
        }

        public final void setThirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(String thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus = thirdPartyFirewallStatus;
            return this;
        }

        @Override
        public final Builder thirdPartyFirewallStatus(ThirdPartyFirewallAssociationStatus thirdPartyFirewallStatus) {
            this.thirdPartyFirewallStatus(thirdPartyFirewallStatus == null ? null : thirdPartyFirewallStatus.toString());
            return this;
        }

        public final String getMarketplaceOnboardingStatus() {
            return marketplaceOnboardingStatus;
        }

        public final void setMarketplaceOnboardingStatus(String marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus = marketplaceOnboardingStatus;
        }

        @Override
        public final Builder marketplaceOnboardingStatus(String marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus = marketplaceOnboardingStatus;
            return this;
        }

        @Override
        public final Builder marketplaceOnboardingStatus(MarketplaceSubscriptionOnboardingStatus marketplaceOnboardingStatus) {
            this.marketplaceOnboardingStatus(marketplaceOnboardingStatus == null ? null : marketplaceOnboardingStatus.toString());
            return this;
        }

        @Override
        public GetThirdPartyFirewallAssociationStatusResponse build() {
            return new GetThirdPartyFirewallAssociationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
