/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeliveryStreamEncryptionConfigurationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<DeliveryStreamEncryptionConfigurationInput.Builder, DeliveryStreamEncryptionConfigurationInput> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyARN")
            .getter(getter(DeliveryStreamEncryptionConfigurationInput::keyARN)).setter(setter(Builder::keyARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyARN").build()).build();

    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyType").getter(getter(DeliveryStreamEncryptionConfigurationInput::keyTypeAsString))
            .setter(setter(Builder::keyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyARN;

    private final String keyType;

    private DeliveryStreamEncryptionConfigurationInput(BuilderImpl builder) {
        this.keyARN = builder.keyARN;
        this.keyType = builder.keyType;
    }

    /**
     * <p>
     * If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon Resource Name
     * (ARN) of the CMK. If you set <code>KeyType</code> to <code>Amazon Web Services_OWNED_CMK</code>, Kinesis Data
     * Firehose uses a service-account CMK.
     * </p>
     * 
     * @return If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon
     *         Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
     *         <code>Amazon Web Services_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.
     */
    public final String keyARN() {
        return keyARN;
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     * <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant
     * that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
     * decryption. Kinesis Data Firehose manages that grant.
     * </p>
     * <p>
     * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is encrypted
     * with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement.
     * </p>
     * <p>
     * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
     * <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis Data
     * Firehose throws a <code>LimitExceededException</code>.
     * </p>
     * <important>
     * <p>
     * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For
     * information about symmetric and asymmetric CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
     * Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     *         <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     *         <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation
     *         <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
     *         create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform
     *         encryption and decryption. Kinesis Data Firehose manages that grant. </p>
     *         <p>
     *         When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
     *         encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK
     *         for retirement.
     *         </p>
     *         <p>
     *         You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
     *         <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis
     *         Data Firehose throws a <code>LimitExceededException</code>.
     *         </p>
     *         <important>
     *         <p>
     *         To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric
     *         CMKs. For information about symmetric and asymmetric CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
     *         Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
     *         </p>
     * @see KeyType
     */
    public final KeyType keyType() {
        return KeyType.fromValue(keyType);
    }

    /**
     * <p>
     * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     * <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
     * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a grant
     * that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
     * decryption. Kinesis Data Firehose manages that grant.
     * </p>
     * <p>
     * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is encrypted
     * with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for retirement.
     * </p>
     * <p>
     * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
     * <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis Data
     * Firehose throws a <code>LimitExceededException</code>.
     * </p>
     * <important>
     * <p>
     * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For
     * information about symmetric and asymmetric CMKs, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
     * Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #keyType} will
     * return {@link KeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyTypeAsString}.
     * </p>
     * 
     * @return Indicates the type of customer master key (CMK) to use for encryption. The default setting is
     *         <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
     *         Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
     *         <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation
     *         <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
     *         create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform
     *         encryption and decryption. Kinesis Data Firehose manages that grant. </p>
     *         <p>
     *         When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
     *         encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK
     *         for retirement.
     *         </p>
     *         <p>
     *         You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
     *         <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis
     *         Data Firehose throws a <code>LimitExceededException</code>.
     *         </p>
     *         <important>
     *         <p>
     *         To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric
     *         CMKs. For information about symmetric and asymmetric CMKs, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
     *         Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
     *         </p>
     * @see KeyType
     */
    public final String keyTypeAsString() {
        return keyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyARN());
        hashCode = 31 * hashCode + Objects.hashCode(keyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfigurationInput)) {
            return false;
        }
        DeliveryStreamEncryptionConfigurationInput other = (DeliveryStreamEncryptionConfigurationInput) obj;
        return Objects.equals(keyARN(), other.keyARN()) && Objects.equals(keyTypeAsString(), other.keyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeliveryStreamEncryptionConfigurationInput").add("KeyARN", keyARN())
                .add("KeyType", keyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyARN":
            return Optional.ofNullable(clazz.cast(keyARN()));
        case "KeyType":
            return Optional.ofNullable(clazz.cast(keyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeliveryStreamEncryptionConfigurationInput, T> g) {
        return obj -> g.apply((DeliveryStreamEncryptionConfigurationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeliveryStreamEncryptionConfigurationInput> {
        /**
         * <p>
         * If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon Resource
         * Name (ARN) of the CMK. If you set <code>KeyType</code> to <code>Amazon Web Services_OWNED_CMK</code>, Kinesis
         * Data Firehose uses a service-account CMK.
         * </p>
         * 
         * @param keyARN
         *        If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code>, you must specify the Amazon
         *        Resource Name (ARN) of the CMK. If you set <code>KeyType</code> to
         *        <code>Amazon Web Services_OWNED_CMK</code>, Kinesis Data Firehose uses a service-account CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyARN(String keyARN);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         * <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
         * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a
         * grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
         * decryption. Kinesis Data Firehose manages that grant.
         * </p>
         * <p>
         * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
         * retirement.
         * </p>
         * <p>
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
         * <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis
         * Data Firehose throws a <code>LimitExceededException</code>.
         * </p>
         * <important>
         * <p>
         * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs.
         * For information about symmetric and asymmetric CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
         * Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
         * </p>
         * </important>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         *        <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
         *        with <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS
         *        operation <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
         *        create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to
         *        perform encryption and decryption. Kinesis Data Firehose manages that grant. </p>
         *        <p>
         *        When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         *        encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK
         *        for retirement.
         *        </p>
         *        <p>
         *        You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
         *        <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit,
         *        Kinesis Data Firehose throws a <code>LimitExceededException</code>.
         *        </p>
         *        <important>
         *        <p>
         *        To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric
         *        CMKs. For information about symmetric and asymmetric CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric
         *        and Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
         *        </p>
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(String keyType);

        /**
         * <p>
         * Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         * <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys
         * (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> with
         * <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a
         * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to create a
         * grant that allows the Kinesis Data Firehose service to use the customer managed CMK to perform encryption and
         * decryption. Kinesis Data Firehose manages that grant.
         * </p>
         * <p>
         * When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         * encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK for
         * retirement.
         * </p>
         * <p>
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
         * <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit, Kinesis
         * Data Firehose throws a <code>LimitExceededException</code>.
         * </p>
         * <important>
         * <p>
         * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs.
         * For information about symmetric and asymmetric CMKs, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and
         * Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
         * </p>
         * </important>
         * 
         * @param keyType
         *        Indicates the type of customer master key (CMK) to use for encryption. The default setting is
         *        <code>Amazon Web Services_OWNED_CMK</code>. For more information about CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master
         *        Keys (CMKs)</a>. When you invoke <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a>
         *        with <code>KeyType</code> set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS
         *        operation <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant</a> to
         *        create a grant that allows the Kinesis Data Firehose service to use the customer managed CMK to
         *        perform encryption and decryption. Kinesis Data Firehose manages that grant. </p>
         *        <p>
         *        When you invoke <a>StartDeliveryStreamEncryption</a> to change the CMK for a delivery stream that is
         *        encrypted with a customer managed CMK, Kinesis Data Firehose schedules the grant it had on the old CMK
         *        for retirement.
         *        </p>
         *        <p>
         *        You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If a
         *        <a>CreateDeliveryStream</a> or <a>StartDeliveryStreamEncryption</a> operation exceeds this limit,
         *        Kinesis Data Firehose throws a <code>LimitExceededException</code>.
         *        </p>
         *        <important>
         *        <p>
         *        To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric
         *        CMKs. For information about symmetric and asymmetric CMKs, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric
         *        and Asymmetric CMKs</a> in the Amazon Web Services Key Management Service developer guide.
         *        </p>
         * @see KeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyType
         */
        Builder keyType(KeyType keyType);
    }

    static final class BuilderImpl implements Builder {
        private String keyARN;

        private String keyType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamEncryptionConfigurationInput model) {
            keyARN(model.keyARN);
            keyType(model.keyType);
        }

        public final String getKeyARN() {
            return keyARN;
        }

        public final void setKeyARN(String keyARN) {
            this.keyARN = keyARN;
        }

        @Override
        public final Builder keyARN(String keyARN) {
            this.keyARN = keyARN;
            return this;
        }

        public final String getKeyType() {
            return keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        @Override
        public DeliveryStreamEncryptionConfigurationInput build() {
            return new DeliveryStreamEncryptionConfigurationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
