/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataBaseClientBuilder;
import software.amazon.awssdk.services.finspacedata.DefaultFinspaceDataClient;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClient;
import software.amazon.awssdk.services.finspacedata.FinspaceDataClientBuilder;
import software.amazon.awssdk.services.finspacedata.FinspaceDataServiceClientConfiguration;
import software.amazon.awssdk.services.finspacedata.endpoints.FinspaceDataEndpointProvider;

@SdkInternalApi
final class DefaultFinspaceDataClientBuilder
extends DefaultFinspaceDataBaseClientBuilder<FinspaceDataClientBuilder, FinspaceDataClient>
implements FinspaceDataClientBuilder {
    DefaultFinspaceDataClientBuilder() {
    }

    @Override
    public DefaultFinspaceDataClientBuilder endpointProvider(FinspaceDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FinspaceDataClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFinspaceDataClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        FinspaceDataServiceClientConfiguration serviceClientConfiguration = FinspaceDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultFinspaceDataClient(serviceClientConfiguration, clientConfiguration);
    }
}

