/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request for creating a data view.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataViewRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<CreateDataViewRequest.Builder, CreateDataViewRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateDataViewRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(CreateDataViewRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoUpdate").getter(getter(CreateDataViewRequest::autoUpdate)).setter(setter(Builder::autoUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()).build();

    private static final SdkField<List<String>> SORT_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sortColumns")
            .getter(getter(CreateDataViewRequest::sortColumns))
            .setter(setter(Builder::sortColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("partitionColumns")
            .getter(getter(CreateDataViewRequest::partitionColumns))
            .setter(setter(Builder::partitionColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> AS_OF_TIMESTAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("asOfTimestamp").getter(getter(CreateDataViewRequest::asOfTimestamp))
            .setter(setter(Builder::asOfTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asOfTimestamp").build()).build();

    private static final SdkField<DataViewDestinationTypeParams> DESTINATION_TYPE_PARAMS_FIELD = SdkField
            .<DataViewDestinationTypeParams> builder(MarshallingType.SDK_POJO).memberName("destinationTypeParams")
            .getter(getter(CreateDataViewRequest::destinationTypeParams)).setter(setter(Builder::destinationTypeParams))
            .constructor(DataViewDestinationTypeParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTypeParams").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DATASET_ID_FIELD, AUTO_UPDATE_FIELD, SORT_COLUMNS_FIELD, PARTITION_COLUMNS_FIELD, AS_OF_TIMESTAMP_FIELD,
            DESTINATION_TYPE_PARAMS_FIELD));

    private final String clientToken;

    private final String datasetId;

    private final Boolean autoUpdate;

    private final List<String> sortColumns;

    private final List<String> partitionColumns;

    private final Long asOfTimestamp;

    private final DataViewDestinationTypeParams destinationTypeParams;

    private CreateDataViewRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.datasetId = builder.datasetId;
        this.autoUpdate = builder.autoUpdate;
        this.sortColumns = builder.sortColumns;
        this.partitionColumns = builder.partitionColumns;
        this.asOfTimestamp = builder.asOfTimestamp;
        this.destinationTypeParams = builder.destinationTypeParams;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique Dataset identifier that is used to create a Dataview.
     * </p>
     * 
     * @return The unique Dataset identifier that is used to create a Dataview.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * Flag to indicate Dataview should be updated automatically.
     * </p>
     * 
     * @return Flag to indicate Dataview should be updated automatically.
     */
    public final Boolean autoUpdate() {
        return autoUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortColumns() {
        return sortColumns != null && !(sortColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Columns to be used for sorting the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortColumns} method.
     * </p>
     * 
     * @return Columns to be used for sorting the data.
     */
    public final List<String> sortColumns() {
        return sortColumns;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionColumns() {
        return partitionColumns != null && !(partitionColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Ordered set of column names used to partition data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionColumns} method.
     * </p>
     * 
     * @return Ordered set of column names used to partition data.
     */
    public final List<String> partitionColumns() {
        return partitionColumns;
    }

    /**
     * <p>
     * Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example, the
     * value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Long asOfTimestamp() {
        return asOfTimestamp;
    }

    /**
     * <p>
     * Options that define the destination type for the Dataview.
     * </p>
     * 
     * @return Options that define the destination type for the Dataview.
     */
    public final DataViewDestinationTypeParams destinationTypeParams() {
        return destinationTypeParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortColumns() ? sortColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionColumns() ? partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(asOfTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeParams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataViewRequest)) {
            return false;
        }
        CreateDataViewRequest other = (CreateDataViewRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(datasetId(), other.datasetId())
                && Objects.equals(autoUpdate(), other.autoUpdate()) && hasSortColumns() == other.hasSortColumns()
                && Objects.equals(sortColumns(), other.sortColumns()) && hasPartitionColumns() == other.hasPartitionColumns()
                && Objects.equals(partitionColumns(), other.partitionColumns())
                && Objects.equals(asOfTimestamp(), other.asOfTimestamp())
                && Objects.equals(destinationTypeParams(), other.destinationTypeParams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataViewRequest").add("ClientToken", clientToken()).add("DatasetId", datasetId())
                .add("AutoUpdate", autoUpdate()).add("SortColumns", hasSortColumns() ? sortColumns() : null)
                .add("PartitionColumns", hasPartitionColumns() ? partitionColumns() : null).add("AsOfTimestamp", asOfTimestamp())
                .add("DestinationTypeParams", destinationTypeParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "autoUpdate":
            return Optional.ofNullable(clazz.cast(autoUpdate()));
        case "sortColumns":
            return Optional.ofNullable(clazz.cast(sortColumns()));
        case "partitionColumns":
            return Optional.ofNullable(clazz.cast(partitionColumns()));
        case "asOfTimestamp":
            return Optional.ofNullable(clazz.cast(asOfTimestamp()));
        case "destinationTypeParams":
            return Optional.ofNullable(clazz.cast(destinationTypeParams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataViewRequest, T> g) {
        return obj -> g.apply((CreateDataViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataViewRequest> {
        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique Dataset identifier that is used to create a Dataview.
         * </p>
         * 
         * @param datasetId
         *        The unique Dataset identifier that is used to create a Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * Flag to indicate Dataview should be updated automatically.
         * </p>
         * 
         * @param autoUpdate
         *        Flag to indicate Dataview should be updated automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpdate(Boolean autoUpdate);

        /**
         * <p>
         * Columns to be used for sorting the data.
         * </p>
         * 
         * @param sortColumns
         *        Columns to be used for sorting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(Collection<String> sortColumns);

        /**
         * <p>
         * Columns to be used for sorting the data.
         * </p>
         * 
         * @param sortColumns
         *        Columns to be used for sorting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortColumns(String... sortColumns);

        /**
         * <p>
         * Ordered set of column names used to partition data.
         * </p>
         * 
         * @param partitionColumns
         *        Ordered set of column names used to partition data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionColumns(Collection<String> partitionColumns);

        /**
         * <p>
         * Ordered set of column names used to partition data.
         * </p>
         * 
         * @param partitionColumns
         *        Ordered set of column names used to partition data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionColumns(String... partitionColumns);

        /**
         * <p>
         * Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For example,
         * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param asOfTimestamp
         *        Beginning time to use for the Dataview. The value is determined as epoch time in milliseconds. For
         *        example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asOfTimestamp(Long asOfTimestamp);

        /**
         * <p>
         * Options that define the destination type for the Dataview.
         * </p>
         * 
         * @param destinationTypeParams
         *        Options that define the destination type for the Dataview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams);

        /**
         * <p>
         * Options that define the destination type for the Dataview.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataViewDestinationTypeParams.Builder}
         * avoiding the need to create one manually via {@link DataViewDestinationTypeParams#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataViewDestinationTypeParams.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationTypeParams(DataViewDestinationTypeParams)}.
         * 
         * @param destinationTypeParams
         *        a consumer that will call methods on {@link DataViewDestinationTypeParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationTypeParams(DataViewDestinationTypeParams)
         */
        default Builder destinationTypeParams(Consumer<DataViewDestinationTypeParams.Builder> destinationTypeParams) {
            return destinationTypeParams(DataViewDestinationTypeParams.builder().applyMutation(destinationTypeParams).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String datasetId;

        private Boolean autoUpdate;

        private List<String> sortColumns = DefaultSdkAutoConstructList.getInstance();

        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();

        private Long asOfTimestamp;

        private DataViewDestinationTypeParams destinationTypeParams;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataViewRequest model) {
            super(model);
            clientToken(model.clientToken);
            datasetId(model.datasetId);
            autoUpdate(model.autoUpdate);
            sortColumns(model.sortColumns);
            partitionColumns(model.partitionColumns);
            asOfTimestamp(model.asOfTimestamp);
            destinationTypeParams(model.destinationTypeParams);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Collection<String> getSortColumns() {
            if (sortColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return sortColumns;
        }

        public final void setSortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
        }

        @Override
        public final Builder sortColumns(Collection<String> sortColumns) {
            this.sortColumns = SortColumnListCopier.copy(sortColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortColumns(String... sortColumns) {
            sortColumns(Arrays.asList(sortColumns));
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = PartitionColumnListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String... partitionColumns) {
            partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final Long getAsOfTimestamp() {
            return asOfTimestamp;
        }

        public final void setAsOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
        }

        @Override
        public final Builder asOfTimestamp(Long asOfTimestamp) {
            this.asOfTimestamp = asOfTimestamp;
            return this;
        }

        public final DataViewDestinationTypeParams.Builder getDestinationTypeParams() {
            return destinationTypeParams != null ? destinationTypeParams.toBuilder() : null;
        }

        public final void setDestinationTypeParams(DataViewDestinationTypeParams.BuilderImpl destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams != null ? destinationTypeParams.build() : null;
        }

        @Override
        public final Builder destinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
            this.destinationTypeParams = destinationTypeParams;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataViewRequest build() {
            return new CreateDataViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
