/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspacedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends FinspaceDataRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(CreateUserRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateUserRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstName").getter(getter(CreateUserRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastName").getter(getter(CreateUserRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()).build();

    private static final SdkField<String> API_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccess").getter(getter(CreateUserRequest::apiAccessAsString)).setter(setter(Builder::apiAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccess").build()).build();

    private static final SdkField<String> API_ACCESS_PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiAccessPrincipalArn").getter(getter(CreateUserRequest::apiAccessPrincipalArn))
            .setter(setter(Builder::apiAccessPrincipalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiAccessPrincipalArn").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateUserRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD,
            TYPE_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, API_ACCESS_FIELD, API_ACCESS_PRINCIPAL_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private final String emailAddress;

    private final String type;

    private final String firstName;

    private final String lastName;

    private final String apiAccess;

    private final String apiAccessPrincipalArn;

    private final String clientToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddress = builder.emailAddress;
        this.type = builder.type;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.apiAccess = builder.apiAccess;
        this.apiAccessPrincipalArn = builder.apiAccessPrincipalArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The email address of the user that you want to register. The email address serves as a uniquer identifier for
     * each user and cannot be changed after it's created.
     * </p>
     * 
     * @return The email address of the user that you want to register. The email address serves as a uniquer identifier
     *         for each user and cannot be changed after it's created.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The option to indicate the type of user. Use one of the following options to specify this parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permission group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final UserType type() {
        return UserType.fromValue(type);
    }

    /**
     * <p>
     * The option to indicate the type of user. Use one of the following options to specify this parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
     * adding them to a permission group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The option to indicate the type of user. Use one of the following options to specify this parameter:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions
     *         by adding them to a permission group.
     *         </p>
     *         </li>
     * @see UserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The first name of the user that you want to register.
     * </p>
     * 
     * @return The first name of the user that you want to register.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the user that you want to register.
     * </p>
     * 
     * @return The last name of the user that you want to register.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
     * credentials that can then be used to access other FinSpace Data API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the APIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any APIs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to
     *         obtain credentials that can then be used to access other FinSpace Data API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the APIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any APIs.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final ApiAccess apiAccess() {
        return ApiAccess.fromValue(apiAccess);
    }

    /**
     * <p>
     * The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to obtain
     * credentials that can then be used to access other FinSpace Data API operations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> – The user has permissions to use the APIs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – The user does not have permissions to use any APIs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #apiAccess} will
     * return {@link ApiAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #apiAccessAsString}.
     * </p>
     * 
     * @return The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to
     *         obtain credentials that can then be used to access other FinSpace Data API operations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> – The user has permissions to use the APIs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – The user does not have permissions to use any APIs.
     *         </p>
     *         </li>
     * @see ApiAccess
     */
    public final String apiAccessAsString() {
        return apiAccess;
    }

    /**
     * <p>
     * The ARN identifier of an AWS user or role that is allowed to call the
     * <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user.
     * This must be an IAM role within your FinSpace account.
     * </p>
     * 
     * @return The ARN identifier of an AWS user or role that is allowed to call the
     *         <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace
     *         user. This must be an IAM role within your FinSpace account.
     */
    public final String apiAccessPrincipalArn() {
        return apiAccessPrincipalArn;
    }

    /**
     * <p>
     * A token that ensures idempotency. This token expires in 10 minutes.
     * </p>
     * 
     * @return A token that ensures idempotency. This token expires in 10 minutes.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiAccessPrincipalArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(apiAccessAsString(), other.apiAccessAsString())
                && Objects.equals(apiAccessPrincipalArn(), other.apiAccessPrincipalArn())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ApiAccess", apiAccessAsString()).add("ApiAccessPrincipalArn", apiAccessPrincipalArn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "firstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "lastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "apiAccess":
            return Optional.ofNullable(clazz.cast(apiAccessAsString()));
        case "apiAccessPrincipalArn":
            return Optional.ofNullable(clazz.cast(apiAccessPrincipalArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The email address of the user that you want to register. The email address serves as a uniquer identifier for
         * each user and cannot be changed after it's created.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user that you want to register. The email address serves as a uniquer
         *        identifier for each user and cannot be changed after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The option to indicate the type of user. Use one of the following options to specify this parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The option to indicate the type of user. Use one of the following options to specify this
         *        parameter:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permission group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(String type);

        /**
         * <p>
         * The option to indicate the type of user. Use one of the following options to specify this parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned permissions by
         * adding them to a permission group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The option to indicate the type of user. Use one of the following options to specify this
         *        parameter:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUPER_USER</code> – A user with permission to all the functionality and data in FinSpace.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APP_USER</code> – A user with specific permissions in FinSpace. The users are assigned
         *        permissions by adding them to a permission group.
         *        </p>
         *        </li>
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(UserType type);

        /**
         * <p>
         * The first name of the user that you want to register.
         * </p>
         * 
         * @param firstName
         *        The first name of the user that you want to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the user that you want to register.
         * </p>
         * 
         * @param lastName
         *        The last name of the user that you want to register.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to
         * obtain credentials that can then be used to access other FinSpace Data API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the APIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any APIs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API
         *        to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the APIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any APIs.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(String apiAccess);

        /**
         * <p>
         * The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API to
         * obtain credentials that can then be used to access other FinSpace Data API operations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> – The user has permissions to use the APIs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – The user does not have permissions to use any APIs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param apiAccess
         *        The option to indicate whether the user can use the <code>GetProgrammaticAccessCredentials</code> API
         *        to obtain credentials that can then be used to access other FinSpace Data API operations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> – The user has permissions to use the APIs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – The user does not have permissions to use any APIs.
         *        </p>
         *        </li>
         * @see ApiAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiAccess
         */
        Builder apiAccess(ApiAccess apiAccess);

        /**
         * <p>
         * The ARN identifier of an AWS user or role that is allowed to call the
         * <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific FinSpace user.
         * This must be an IAM role within your FinSpace account.
         * </p>
         * 
         * @param apiAccessPrincipalArn
         *        The ARN identifier of an AWS user or role that is allowed to call the
         *        <code>GetProgrammaticAccessCredentials</code> API to obtain a credentials token for a specific
         *        FinSpace user. This must be an IAM role within your FinSpace account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiAccessPrincipalArn(String apiAccessPrincipalArn);

        /**
         * <p>
         * A token that ensures idempotency. This token expires in 10 minutes.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures idempotency. This token expires in 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceDataRequest.BuilderImpl implements Builder {
        private String emailAddress;

        private String type;

        private String firstName;

        private String lastName;

        private String apiAccess;

        private String apiAccessPrincipalArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            emailAddress(model.emailAddress);
            type(model.type);
            firstName(model.firstName);
            lastName(model.lastName);
            apiAccess(model.apiAccess);
            apiAccessPrincipalArn(model.apiAccessPrincipalArn);
            clientToken(model.clientToken);
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getApiAccess() {
            return apiAccess;
        }

        public final void setApiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
        }

        @Override
        public final Builder apiAccess(String apiAccess) {
            this.apiAccess = apiAccess;
            return this;
        }

        @Override
        public final Builder apiAccess(ApiAccess apiAccess) {
            this.apiAccess(apiAccess == null ? null : apiAccess.toString());
            return this;
        }

        public final String getApiAccessPrincipalArn() {
            return apiAccessPrincipalArn;
        }

        public final void setApiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
        }

        @Override
        public final Builder apiAccessPrincipalArn(String apiAccessPrincipalArn) {
            this.apiAccessPrincipalArn = apiAccessPrincipalArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
