/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKxClustersResponse extends FinspaceResponse implements
        ToCopyableBuilder<ListKxClustersResponse.Builder, ListKxClustersResponse> {
    private static final SdkField<List<KxCluster>> KX_CLUSTER_SUMMARIES_FIELD = SdkField
            .<List<KxCluster>> builder(MarshallingType.LIST)
            .memberName("kxClusterSummaries")
            .getter(getter(ListKxClustersResponse::kxClusterSummaries))
            .setter(setter(Builder::kxClusterSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxClusterSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KxCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(KxCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListKxClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_CLUSTER_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<KxCluster> kxClusterSummaries;

    private final String nextToken;

    private ListKxClustersResponse(BuilderImpl builder) {
        super(builder);
        this.kxClusterSummaries = builder.kxClusterSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the KxClusterSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKxClusterSummaries() {
        return kxClusterSummaries != null && !(kxClusterSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the cluster details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKxClusterSummaries} method.
     * </p>
     * 
     * @return Lists the cluster details.
     */
    public final List<KxCluster> kxClusterSummaries() {
        return kxClusterSummaries;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasKxClusterSummaries() ? kxClusterSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxClustersResponse)) {
            return false;
        }
        ListKxClustersResponse other = (ListKxClustersResponse) obj;
        return hasKxClusterSummaries() == other.hasKxClusterSummaries()
                && Objects.equals(kxClusterSummaries(), other.kxClusterSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKxClustersResponse")
                .add("KxClusterSummaries", hasKxClusterSummaries() ? kxClusterSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kxClusterSummaries":
            return Optional.ofNullable(clazz.cast(kxClusterSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxClustersResponse, T> g) {
        return obj -> g.apply((ListKxClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKxClustersResponse> {
        /**
         * <p>
         * Lists the cluster details.
         * </p>
         * 
         * @param kxClusterSummaries
         *        Lists the cluster details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kxClusterSummaries(Collection<KxCluster> kxClusterSummaries);

        /**
         * <p>
         * Lists the cluster details.
         * </p>
         * 
         * @param kxClusterSummaries
         *        Lists the cluster details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kxClusterSummaries(KxCluster... kxClusterSummaries);

        /**
         * <p>
         * Lists the cluster details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.KxCluster.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.finspace.model.KxCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.KxCluster.Builder#build()} is called immediately and
         * its result is passed to {@link #kxClusterSummaries(List<KxCluster>)}.
         * 
         * @param kxClusterSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.KxCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kxClusterSummaries(java.util.Collection<KxCluster>)
         */
        Builder kxClusterSummaries(Consumer<KxCluster.Builder>... kxClusterSummaries);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private List<KxCluster> kxClusterSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxClustersResponse model) {
            super(model);
            kxClusterSummaries(model.kxClusterSummaries);
            nextToken(model.nextToken);
        }

        public final List<KxCluster.Builder> getKxClusterSummaries() {
            List<KxCluster.Builder> result = KxClustersCopier.copyToBuilder(this.kxClusterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxClusterSummaries(Collection<KxCluster.BuilderImpl> kxClusterSummaries) {
            this.kxClusterSummaries = KxClustersCopier.copyFromBuilder(kxClusterSummaries);
        }

        @Override
        public final Builder kxClusterSummaries(Collection<KxCluster> kxClusterSummaries) {
            this.kxClusterSummaries = KxClustersCopier.copy(kxClusterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxClusterSummaries(KxCluster... kxClusterSummaries) {
            kxClusterSummaries(Arrays.asList(kxClusterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxClusterSummaries(Consumer<KxCluster.Builder>... kxClusterSummaries) {
            kxClusterSummaries(Stream.of(kxClusterSummaries).map(c -> KxCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxClustersResponse build() {
            return new ListKxClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
