/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxChangesetListEntry;
import software.amazon.awssdk.services.finspace.model.KxChangesetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxChangesetsResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxChangesetsResponse> {
    private static final SdkField<List<KxChangesetListEntry>> KX_CHANGESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kxChangesets").getter(ListKxChangesetsResponse.getter(ListKxChangesetsResponse::kxChangesets)).setter(ListKxChangesetsResponse.setter(Builder::kxChangesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxChangesets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxChangesetListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxChangesetsResponse.getter(ListKxChangesetsResponse::nextToken)).setter(ListKxChangesetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_CHANGESETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<KxChangesetListEntry> kxChangesets;
    private final String nextToken;

    private ListKxChangesetsResponse(BuilderImpl builder) {
        super(builder);
        this.kxChangesets = builder.kxChangesets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKxChangesets() {
        return this.kxChangesets != null && !(this.kxChangesets instanceof SdkAutoConstructList);
    }

    public final List<KxChangesetListEntry> kxChangesets() {
        return this.kxChangesets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKxChangesets() ? this.kxChangesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxChangesetsResponse)) {
            return false;
        }
        ListKxChangesetsResponse other = (ListKxChangesetsResponse)((Object)obj);
        return this.hasKxChangesets() == other.hasKxChangesets() && Objects.equals(this.kxChangesets(), other.kxChangesets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxChangesetsResponse").add("KxChangesets", this.hasKxChangesets() ? this.kxChangesets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kxChangesets": {
                return Optional.ofNullable(clazz.cast(this.kxChangesets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxChangesetsResponse, T> g) {
        return obj -> g.apply((ListKxChangesetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxChangesetListEntry> kxChangesets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxChangesetsResponse model) {
            super(model);
            this.kxChangesets(model.kxChangesets);
            this.nextToken(model.nextToken);
        }

        public final List<KxChangesetListEntry.Builder> getKxChangesets() {
            List<KxChangesetListEntry.Builder> result = KxChangesetsCopier.copyToBuilder(this.kxChangesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxChangesets(Collection<KxChangesetListEntry.BuilderImpl> kxChangesets) {
            this.kxChangesets = KxChangesetsCopier.copyFromBuilder(kxChangesets);
        }

        @Override
        public final Builder kxChangesets(Collection<KxChangesetListEntry> kxChangesets) {
            this.kxChangesets = KxChangesetsCopier.copy(kxChangesets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxChangesets(KxChangesetListEntry ... kxChangesets) {
            this.kxChangesets(Arrays.asList(kxChangesets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxChangesets(Consumer<KxChangesetListEntry.Builder> ... kxChangesets) {
            this.kxChangesets(Stream.of(kxChangesets).map(c -> (KxChangesetListEntry)((KxChangesetListEntry.Builder)KxChangesetListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxChangesetsResponse build() {
            return new ListKxChangesetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxChangesetsResponse> {
        public Builder kxChangesets(Collection<KxChangesetListEntry> var1);

        public Builder kxChangesets(KxChangesetListEntry ... var1);

        public Builder kxChangesets(Consumer<KxChangesetListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

