/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetKxEnvironmentResponse extends FinspaceResponse implements
        ToCopyableBuilder<GetKxEnvironmentResponse.Builder, GetKxEnvironmentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetKxEnvironmentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetKxEnvironmentResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(GetKxEnvironmentResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetKxEnvironmentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TGW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tgwStatus").getter(getter(GetKxEnvironmentResponse::tgwStatusAsString))
            .setter(setter(Builder::tgwStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tgwStatus").build()).build();

    private static final SdkField<String> DNS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsStatus").getter(getter(GetKxEnvironmentResponse::dnsStatusAsString))
            .setter(setter(Builder::dnsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsStatus").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetKxEnvironmentResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetKxEnvironmentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentArn").getter(getter(GetKxEnvironmentResponse::environmentArn))
            .setter(setter(Builder::environmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(GetKxEnvironmentResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> DEDICATED_SERVICE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dedicatedServiceAccountId").getter(getter(GetKxEnvironmentResponse::dedicatedServiceAccountId))
            .setter(setter(Builder::dedicatedServiceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedServiceAccountId").build())
            .build();

    private static final SdkField<TransitGatewayConfiguration> TRANSIT_GATEWAY_CONFIGURATION_FIELD = SdkField
            .<TransitGatewayConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("transitGatewayConfiguration")
            .getter(getter(GetKxEnvironmentResponse::transitGatewayConfiguration))
            .setter(setter(Builder::transitGatewayConfiguration))
            .constructor(TransitGatewayConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayConfiguration")
                    .build()).build();

    private static final SdkField<List<CustomDNSServer>> CUSTOM_DNS_CONFIGURATION_FIELD = SdkField
            .<List<CustomDNSServer>> builder(MarshallingType.LIST)
            .memberName("customDNSConfiguration")
            .getter(getter(GetKxEnvironmentResponse::customDNSConfiguration))
            .setter(setter(Builder::customDNSConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDNSConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDNSServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDNSServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(GetKxEnvironmentResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<Instant> UPDATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTimestamp").getter(getter(GetKxEnvironmentResponse::updateTimestamp))
            .setter(setter(Builder::updateTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTimestamp").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("availabilityZoneIds")
            .getter(getter(GetKxEnvironmentResponse::availabilityZoneIds))
            .setter(setter(Builder::availabilityZoneIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateAuthorityArn").getter(getter(GetKxEnvironmentResponse::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthorityArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ENVIRONMENT_ID_FIELD, AWS_ACCOUNT_ID_FIELD, STATUS_FIELD, TGW_STATUS_FIELD, DNS_STATUS_FIELD, ERROR_MESSAGE_FIELD,
            DESCRIPTION_FIELD, ENVIRONMENT_ARN_FIELD, KMS_KEY_ID_FIELD, DEDICATED_SERVICE_ACCOUNT_ID_FIELD,
            TRANSIT_GATEWAY_CONFIGURATION_FIELD, CUSTOM_DNS_CONFIGURATION_FIELD, CREATION_TIMESTAMP_FIELD,
            UPDATE_TIMESTAMP_FIELD, AVAILABILITY_ZONE_IDS_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD));

    private final String name;

    private final String environmentId;

    private final String awsAccountId;

    private final String status;

    private final String tgwStatus;

    private final String dnsStatus;

    private final String errorMessage;

    private final String description;

    private final String environmentArn;

    private final String kmsKeyId;

    private final String dedicatedServiceAccountId;

    private final TransitGatewayConfiguration transitGatewayConfiguration;

    private final List<CustomDNSServer> customDNSConfiguration;

    private final Instant creationTimestamp;

    private final Instant updateTimestamp;

    private final List<String> availabilityZoneIds;

    private final String certificateAuthorityArn;

    private GetKxEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.environmentId = builder.environmentId;
        this.awsAccountId = builder.awsAccountId;
        this.status = builder.status;
        this.tgwStatus = builder.tgwStatus;
        this.dnsStatus = builder.dnsStatus;
        this.errorMessage = builder.errorMessage;
        this.description = builder.description;
        this.environmentArn = builder.environmentArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.dedicatedServiceAccountId = builder.dedicatedServiceAccountId;
        this.transitGatewayConfiguration = builder.transitGatewayConfiguration;
        this.customDNSConfiguration = builder.customDNSConfiguration;
        this.creationTimestamp = builder.creationTimestamp;
        this.updateTimestamp = builder.updateTimestamp;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
    }

    /**
     * <p>
     * The name of the kdb environment.
     * </p>
     * 
     * @return The name of the kdb environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The unique identifier of the AWS account that is used to create the kdb environment.
     * </p>
     * 
     * @return The unique identifier of the AWS account that is used to create the kdb environment.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The status of the kdb environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the kdb environment.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the kdb environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the kdb environment.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status of the network configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tgwStatus} will
     * return {@link TgwStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tgwStatusAsString}.
     * </p>
     * 
     * @return The status of the network configuration.
     * @see TgwStatus
     */
    public final TgwStatus tgwStatus() {
        return TgwStatus.fromValue(tgwStatus);
    }

    /**
     * <p>
     * The status of the network configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tgwStatus} will
     * return {@link TgwStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tgwStatusAsString}.
     * </p>
     * 
     * @return The status of the network configuration.
     * @see TgwStatus
     */
    public final String tgwStatusAsString() {
        return tgwStatus;
    }

    /**
     * <p>
     * The status of DNS configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsStatus} will
     * return {@link DnsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsStatusAsString}.
     * </p>
     * 
     * @return The status of DNS configuration.
     * @see DnsStatus
     */
    public final DnsStatus dnsStatus() {
        return DnsStatus.fromValue(dnsStatus);
    }

    /**
     * <p>
     * The status of DNS configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsStatus} will
     * return {@link DnsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsStatusAsString}.
     * </p>
     * 
     * @return The status of DNS configuration.
     * @see DnsStatus
     */
    public final String dnsStatusAsString() {
        return dnsStatus;
    }

    /**
     * <p>
     * Specifies the error message that appears if a flow fails.
     * </p>
     * 
     * @return Specifies the error message that appears if a flow fails.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * A description for the kdb environment.
     * </p>
     * 
     * @return A description for the kdb environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN identifier of the environment.
     * </p>
     * 
     * @return The ARN identifier of the environment.
     */
    public final String environmentArn() {
        return environmentArn;
    }

    /**
     * <p>
     * The KMS key ID to encrypt your data in the FinSpace environment.
     * </p>
     * 
     * @return The KMS key ID to encrypt your data in the FinSpace environment.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A unique identifier for the AWS environment infrastructure account.
     * </p>
     * 
     * @return A unique identifier for the AWS environment infrastructure account.
     */
    public final String dedicatedServiceAccountId() {
        return dedicatedServiceAccountId;
    }

    /**
     * Returns the value of the TransitGatewayConfiguration property for this object.
     * 
     * @return The value of the TransitGatewayConfiguration property for this object.
     */
    public final TransitGatewayConfiguration transitGatewayConfiguration() {
        return transitGatewayConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDNSConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomDNSConfiguration() {
        return customDNSConfiguration != null && !(customDNSConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDNSConfiguration} method.
     * </p>
     * 
     * @return A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
     */
    public final List<CustomDNSServer> customDNSConfiguration() {
        return customDNSConfiguration;
    }

    /**
     * <p>
     * The timestamp at which the kdb environment was created in FinSpace.
     * </p>
     * 
     * @return The timestamp at which the kdb environment was created in FinSpace.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The timestamp at which the kdb environment was updated.
     * </p>
     * 
     * @return The timestamp at which the kdb environment was updated.
     */
    public final Instant updateTimestamp() {
        return updateTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZoneIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZoneIds() {
        return availabilityZoneIds != null && !(availabilityZoneIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the availability zones where subnets for the environment are created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZoneIds} method.
     * </p>
     * 
     * @return The identifier of the availability zones where subnets for the environment are created.
     */
    public final List<String> availabilityZoneIds() {
        return availabilityZoneIds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tgwStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedServiceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDNSConfiguration() ? customDNSConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZoneIds() ? availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxEnvironmentResponse)) {
            return false;
        }
        GetKxEnvironmentResponse other = (GetKxEnvironmentResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(tgwStatusAsString(), other.tgwStatusAsString())
                && Objects.equals(dnsStatusAsString(), other.dnsStatusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(description(), other.description())
                && Objects.equals(environmentArn(), other.environmentArn()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dedicatedServiceAccountId(), other.dedicatedServiceAccountId())
                && Objects.equals(transitGatewayConfiguration(), other.transitGatewayConfiguration())
                && hasCustomDNSConfiguration() == other.hasCustomDNSConfiguration()
                && Objects.equals(customDNSConfiguration(), other.customDNSConfiguration())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(updateTimestamp(), other.updateTimestamp())
                && hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds()
                && Objects.equals(availabilityZoneIds(), other.availabilityZoneIds())
                && Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetKxEnvironmentResponse").add("Name", name()).add("EnvironmentId", environmentId())
                .add("AwsAccountId", awsAccountId()).add("Status", statusAsString()).add("TgwStatus", tgwStatusAsString())
                .add("DnsStatus", dnsStatusAsString()).add("ErrorMessage", errorMessage()).add("Description", description())
                .add("EnvironmentArn", environmentArn()).add("KmsKeyId", kmsKeyId())
                .add("DedicatedServiceAccountId", dedicatedServiceAccountId())
                .add("TransitGatewayConfiguration", transitGatewayConfiguration())
                .add("CustomDNSConfiguration", hasCustomDNSConfiguration() ? customDNSConfiguration() : null)
                .add("CreationTimestamp", creationTimestamp()).add("UpdateTimestamp", updateTimestamp())
                .add("AvailabilityZoneIds", hasAvailabilityZoneIds() ? availabilityZoneIds() : null)
                .add("CertificateAuthorityArn", certificateAuthorityArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tgwStatus":
            return Optional.ofNullable(clazz.cast(tgwStatusAsString()));
        case "dnsStatus":
            return Optional.ofNullable(clazz.cast(dnsStatusAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "environmentArn":
            return Optional.ofNullable(clazz.cast(environmentArn()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "dedicatedServiceAccountId":
            return Optional.ofNullable(clazz.cast(dedicatedServiceAccountId()));
        case "transitGatewayConfiguration":
            return Optional.ofNullable(clazz.cast(transitGatewayConfiguration()));
        case "customDNSConfiguration":
            return Optional.ofNullable(clazz.cast(customDNSConfiguration()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "updateTimestamp":
            return Optional.ofNullable(clazz.cast(updateTimestamp()));
        case "availabilityZoneIds":
            return Optional.ofNullable(clazz.cast(availabilityZoneIds()));
        case "certificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKxEnvironmentResponse, T> g) {
        return obj -> g.apply((GetKxEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetKxEnvironmentResponse> {
        /**
         * <p>
         * The name of the kdb environment.
         * </p>
         * 
         * @param name
         *        The name of the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The unique identifier of the AWS account that is used to create the kdb environment.
         * </p>
         * 
         * @param awsAccountId
         *        The unique identifier of the AWS account that is used to create the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The status of the kdb environment.
         * </p>
         * 
         * @param status
         *        The status of the kdb environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the kdb environment.
         * </p>
         * 
         * @param status
         *        The status of the kdb environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The status of the network configuration.
         * </p>
         * 
         * @param tgwStatus
         *        The status of the network configuration.
         * @see TgwStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TgwStatus
         */
        Builder tgwStatus(String tgwStatus);

        /**
         * <p>
         * The status of the network configuration.
         * </p>
         * 
         * @param tgwStatus
         *        The status of the network configuration.
         * @see TgwStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TgwStatus
         */
        Builder tgwStatus(TgwStatus tgwStatus);

        /**
         * <p>
         * The status of DNS configuration.
         * </p>
         * 
         * @param dnsStatus
         *        The status of DNS configuration.
         * @see DnsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsStatus
         */
        Builder dnsStatus(String dnsStatus);

        /**
         * <p>
         * The status of DNS configuration.
         * </p>
         * 
         * @param dnsStatus
         *        The status of DNS configuration.
         * @see DnsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsStatus
         */
        Builder dnsStatus(DnsStatus dnsStatus);

        /**
         * <p>
         * Specifies the error message that appears if a flow fails.
         * </p>
         * 
         * @param errorMessage
         *        Specifies the error message that appears if a flow fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * A description for the kdb environment.
         * </p>
         * 
         * @param description
         *        A description for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN identifier of the environment.
         * </p>
         * 
         * @param environmentArn
         *        The ARN identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentArn(String environmentArn);

        /**
         * <p>
         * The KMS key ID to encrypt your data in the FinSpace environment.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key ID to encrypt your data in the FinSpace environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A unique identifier for the AWS environment infrastructure account.
         * </p>
         * 
         * @param dedicatedServiceAccountId
         *        A unique identifier for the AWS environment infrastructure account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedServiceAccountId(String dedicatedServiceAccountId);

        /**
         * Sets the value of the TransitGatewayConfiguration property for this object.
         *
         * @param transitGatewayConfiguration
         *        The new value for the TransitGatewayConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration);

        /**
         * Sets the value of the TransitGatewayConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TransitGatewayConfiguration.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #transitGatewayConfiguration(TransitGatewayConfiguration)}.
         * 
         * @param transitGatewayConfiguration
         *        a consumer that will call methods on {@link TransitGatewayConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayConfiguration(TransitGatewayConfiguration)
         */
        default Builder transitGatewayConfiguration(Consumer<TransitGatewayConfiguration.Builder> transitGatewayConfiguration) {
            return transitGatewayConfiguration(TransitGatewayConfiguration.builder().applyMutation(transitGatewayConfiguration)
                    .build());
        }

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * 
         * @param customDNSConfiguration
         *        A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration);

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * 
         * @param customDNSConfiguration
         *        A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDNSConfiguration(CustomDNSServer... customDNSConfiguration);

        /**
         * <p>
         * A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder#build()} is called immediately
         * and its result is passed to {@link #customDNSConfiguration(List<CustomDNSServer>)}.
         * 
         * @param customDNSConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.finspace.model.CustomDNSServer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDNSConfiguration(java.util.Collection<CustomDNSServer>)
         */
        Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder>... customDNSConfiguration);

        /**
         * <p>
         * The timestamp at which the kdb environment was created in FinSpace.
         * </p>
         * 
         * @param creationTimestamp
         *        The timestamp at which the kdb environment was created in FinSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The timestamp at which the kdb environment was updated.
         * </p>
         * 
         * @param updateTimestamp
         *        The timestamp at which the kdb environment was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTimestamp(Instant updateTimestamp);

        /**
         * <p>
         * The identifier of the availability zones where subnets for the environment are created.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones where subnets for the environment are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(Collection<String> availabilityZoneIds);

        /**
         * <p>
         * The identifier of the availability zones where subnets for the environment are created.
         * </p>
         * 
         * @param availabilityZoneIds
         *        The identifier of the availability zones where subnets for the environment are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneIds(String... availabilityZoneIds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.
         * </p>
         * 
         * @param certificateAuthorityArn
         *        The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String name;

        private String environmentId;

        private String awsAccountId;

        private String status;

        private String tgwStatus;

        private String dnsStatus;

        private String errorMessage;

        private String description;

        private String environmentArn;

        private String kmsKeyId;

        private String dedicatedServiceAccountId;

        private TransitGatewayConfiguration transitGatewayConfiguration;

        private List<CustomDNSServer> customDNSConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTimestamp;

        private Instant updateTimestamp;

        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();

        private String certificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxEnvironmentResponse model) {
            super(model);
            name(model.name);
            environmentId(model.environmentId);
            awsAccountId(model.awsAccountId);
            status(model.status);
            tgwStatus(model.tgwStatus);
            dnsStatus(model.dnsStatus);
            errorMessage(model.errorMessage);
            description(model.description);
            environmentArn(model.environmentArn);
            kmsKeyId(model.kmsKeyId);
            dedicatedServiceAccountId(model.dedicatedServiceAccountId);
            transitGatewayConfiguration(model.transitGatewayConfiguration);
            customDNSConfiguration(model.customDNSConfiguration);
            creationTimestamp(model.creationTimestamp);
            updateTimestamp(model.updateTimestamp);
            availabilityZoneIds(model.availabilityZoneIds);
            certificateAuthorityArn(model.certificateAuthorityArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTgwStatus() {
            return tgwStatus;
        }

        public final void setTgwStatus(String tgwStatus) {
            this.tgwStatus = tgwStatus;
        }

        @Override
        public final Builder tgwStatus(String tgwStatus) {
            this.tgwStatus = tgwStatus;
            return this;
        }

        @Override
        public final Builder tgwStatus(TgwStatus tgwStatus) {
            this.tgwStatus(tgwStatus == null ? null : tgwStatus.toString());
            return this;
        }

        public final String getDnsStatus() {
            return dnsStatus;
        }

        public final void setDnsStatus(String dnsStatus) {
            this.dnsStatus = dnsStatus;
        }

        @Override
        public final Builder dnsStatus(String dnsStatus) {
            this.dnsStatus = dnsStatus;
            return this;
        }

        @Override
        public final Builder dnsStatus(DnsStatus dnsStatus) {
            this.dnsStatus(dnsStatus == null ? null : dnsStatus.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironmentArn() {
            return environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDedicatedServiceAccountId() {
            return dedicatedServiceAccountId;
        }

        public final void setDedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
        }

        @Override
        public final Builder dedicatedServiceAccountId(String dedicatedServiceAccountId) {
            this.dedicatedServiceAccountId = dedicatedServiceAccountId;
            return this;
        }

        public final TransitGatewayConfiguration.Builder getTransitGatewayConfiguration() {
            return transitGatewayConfiguration != null ? transitGatewayConfiguration.toBuilder() : null;
        }

        public final void setTransitGatewayConfiguration(TransitGatewayConfiguration.BuilderImpl transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration != null ? transitGatewayConfiguration.build() : null;
        }

        @Override
        public final Builder transitGatewayConfiguration(TransitGatewayConfiguration transitGatewayConfiguration) {
            this.transitGatewayConfiguration = transitGatewayConfiguration;
            return this;
        }

        public final List<CustomDNSServer.Builder> getCustomDNSConfiguration() {
            List<CustomDNSServer.Builder> result = CustomDNSConfigurationCopier.copyToBuilder(this.customDNSConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDNSConfiguration(Collection<CustomDNSServer.BuilderImpl> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copyFromBuilder(customDNSConfiguration);
        }

        @Override
        public final Builder customDNSConfiguration(Collection<CustomDNSServer> customDNSConfiguration) {
            this.customDNSConfiguration = CustomDNSConfigurationCopier.copy(customDNSConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(CustomDNSServer... customDNSConfiguration) {
            customDNSConfiguration(Arrays.asList(customDNSConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDNSConfiguration(Consumer<CustomDNSServer.Builder>... customDNSConfiguration) {
            customDNSConfiguration(Stream.of(customDNSConfiguration).map(c -> CustomDNSServer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getUpdateTimestamp() {
            return updateTimestamp;
        }

        public final void setUpdateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
        }

        @Override
        public final Builder updateTimestamp(Instant updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String... availabilityZoneIds) {
            availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        @Override
        public GetKxEnvironmentResponse build() {
            return new GetKxEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
