/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.Launch;
import software.amazon.awssdk.services.evidently.model.ListLaunchesRequest;
import software.amazon.awssdk.services.evidently.model.ListLaunchesResponse;

public class ListLaunchesIterable
implements SdkIterable<ListLaunchesResponse> {
    private final EvidentlyClient client;
    private final ListLaunchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchesIterable(EvidentlyClient client, ListLaunchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLaunchesResponseFetcher();
    }

    public Iterator<ListLaunchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Launch> launches() {
        Function<ListLaunchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.launches() != null) {
                return response.launches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLaunchesResponseFetcher
    implements SyncPageFetcher<ListLaunchesResponse> {
        private ListLaunchesResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLaunchesResponse nextPage(ListLaunchesResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchesIterable.this.client.listLaunches(ListLaunchesIterable.this.firstRequest);
            }
            return ListLaunchesIterable.this.client.listLaunches((ListLaunchesRequest)((Object)ListLaunchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

