/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartJobRunRequest extends EmrContainersRequest implements
        ToCopyableBuilder<StartJobRunRequest.Builder, StartJobRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartJobRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterId").getter(getter(StartJobRunRequest::virtualClusterId))
            .setter(setter(Builder::virtualClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartJobRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(StartJobRunRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(StartJobRunRequest::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.<JobDriver> builder(MarshallingType.SDK_POJO)
            .memberName("jobDriver").getter(getter(StartJobRunRequest::jobDriver)).setter(setter(Builder::jobDriver))
            .constructor(JobDriver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()).build();

    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField
            .<ConfigurationOverrides> builder(MarshallingType.SDK_POJO).memberName("configurationOverrides")
            .getter(getter(StartJobRunRequest::configurationOverrides)).setter(setter(Builder::configurationOverrides))
            .constructor(ConfigurationOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartJobRunRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateId").getter(getter(StartJobRunRequest::jobTemplateId)).setter(setter(Builder::jobTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateId").build()).build();

    private static final SdkField<Map<String, String>> JOB_TEMPLATE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("jobTemplateParameters")
            .getter(getter(StartJobRunRequest::jobTemplateParameters))
            .setter(setter(Builder::jobTemplateParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<RetryPolicyConfiguration> RETRY_POLICY_CONFIGURATION_FIELD = SdkField
            .<RetryPolicyConfiguration> builder(MarshallingType.SDK_POJO).memberName("retryPolicyConfiguration")
            .getter(getter(StartJobRunRequest::retryPolicyConfiguration)).setter(setter(Builder::retryPolicyConfiguration))
            .constructor(RetryPolicyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VIRTUAL_CLUSTER_ID_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, RELEASE_LABEL_FIELD, JOB_DRIVER_FIELD,
            CONFIGURATION_OVERRIDES_FIELD, TAGS_FIELD, JOB_TEMPLATE_ID_FIELD, JOB_TEMPLATE_PARAMETERS_FIELD,
            RETRY_POLICY_CONFIGURATION_FIELD));

    private final String name;

    private final String virtualClusterId;

    private final String clientToken;

    private final String executionRoleArn;

    private final String releaseLabel;

    private final JobDriver jobDriver;

    private final ConfigurationOverrides configurationOverrides;

    private final Map<String, String> tags;

    private final String jobTemplateId;

    private final Map<String, String> jobTemplateParameters;

    private final RetryPolicyConfiguration retryPolicyConfiguration;

    private StartJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.virtualClusterId = builder.virtualClusterId;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.jobDriver = builder.jobDriver;
        this.configurationOverrides = builder.configurationOverrides;
        this.tags = builder.tags;
        this.jobTemplateId = builder.jobTemplateId;
        this.jobTemplateParameters = builder.jobTemplateParameters;
        this.retryPolicyConfiguration = builder.retryPolicyConfiguration;
    }

    /**
     * <p>
     * The name of the job run.
     * </p>
     * 
     * @return The name of the job run.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The virtual cluster ID for which the job run request is submitted.
     * </p>
     * 
     * @return The virtual cluster ID for which the job run request is submitted.
     */
    public final String virtualClusterId() {
        return virtualClusterId;
    }

    /**
     * <p>
     * The client idempotency token of the job run request.
     * </p>
     * 
     * @return The client idempotency token of the job run request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The execution role ARN for the job run.
     * </p>
     * 
     * @return The execution role ARN for the job run.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Amazon EMR release version to use for the job run.
     * </p>
     * 
     * @return The Amazon EMR release version to use for the job run.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The job driver for the job run.
     * </p>
     * 
     * @return The job driver for the job run.
     */
    public final JobDriver jobDriver() {
        return jobDriver;
    }

    /**
     * <p>
     * The configuration overrides for the job run.
     * </p>
     * 
     * @return The configuration overrides for the job run.
     */
    public final ConfigurationOverrides configurationOverrides() {
        return configurationOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to job runs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to job runs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The job template ID to be used to start the job run.
     * </p>
     * 
     * @return The job template ID to be used to start the job run.
     */
    public final String jobTemplateId() {
        return jobTemplateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTemplateParameters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasJobTemplateParameters() {
        return jobTemplateParameters != null && !(jobTemplateParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The values of job template parameters to start a job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTemplateParameters} method.
     * </p>
     * 
     * @return The values of job template parameters to start a job run.
     */
    public final Map<String, String> jobTemplateParameters() {
        return jobTemplateParameters;
    }

    /**
     * <p>
     * The retry policy configuration for the job run.
     * </p>
     * 
     * @return The retry policy configuration for the job run.
     */
    public final RetryPolicyConfiguration retryPolicyConfiguration() {
        return retryPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTemplateParameters() ? jobTemplateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retryPolicyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartJobRunRequest)) {
            return false;
        }
        StartJobRunRequest other = (StartJobRunRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(virtualClusterId(), other.virtualClusterId())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(jobDriver(), other.jobDriver())
                && Objects.equals(configurationOverrides(), other.configurationOverrides()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(jobTemplateId(), other.jobTemplateId())
                && hasJobTemplateParameters() == other.hasJobTemplateParameters()
                && Objects.equals(jobTemplateParameters(), other.jobTemplateParameters())
                && Objects.equals(retryPolicyConfiguration(), other.retryPolicyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartJobRunRequest").add("Name", name()).add("VirtualClusterId", virtualClusterId())
                .add("ClientToken", clientToken()).add("ExecutionRoleArn", executionRoleArn())
                .add("ReleaseLabel", releaseLabel()).add("JobDriver", jobDriver())
                .add("ConfigurationOverrides", configurationOverrides()).add("Tags", hasTags() ? tags() : null)
                .add("JobTemplateId", jobTemplateId())
                .add("JobTemplateParameters", hasJobTemplateParameters() ? jobTemplateParameters() : null)
                .add("RetryPolicyConfiguration", retryPolicyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "virtualClusterId":
            return Optional.ofNullable(clazz.cast(virtualClusterId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "jobDriver":
            return Optional.ofNullable(clazz.cast(jobDriver()));
        case "configurationOverrides":
            return Optional.ofNullable(clazz.cast(configurationOverrides()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "jobTemplateId":
            return Optional.ofNullable(clazz.cast(jobTemplateId()));
        case "jobTemplateParameters":
            return Optional.ofNullable(clazz.cast(jobTemplateParameters()));
        case "retryPolicyConfiguration":
            return Optional.ofNullable(clazz.cast(retryPolicyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartJobRunRequest, T> g) {
        return obj -> g.apply((StartJobRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartJobRunRequest> {
        /**
         * <p>
         * The name of the job run.
         * </p>
         * 
         * @param name
         *        The name of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The virtual cluster ID for which the job run request is submitted.
         * </p>
         * 
         * @param virtualClusterId
         *        The virtual cluster ID for which the job run request is submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterId(String virtualClusterId);

        /**
         * <p>
         * The client idempotency token of the job run request.
         * </p>
         * 
         * @param clientToken
         *        The client idempotency token of the job run request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The execution role ARN for the job run.
         * </p>
         * 
         * @param executionRoleArn
         *        The execution role ARN for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon EMR release version to use for the job run.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release version to use for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The job driver for the job run.
         * </p>
         * 
         * @param jobDriver
         *        The job driver for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDriver(JobDriver jobDriver);

        /**
         * <p>
         * The job driver for the job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDriver.Builder} avoiding the need to
         * create one manually via {@link JobDriver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobDriver.Builder#build()} is called immediately and its result
         * is passed to {@link #jobDriver(JobDriver)}.
         * 
         * @param jobDriver
         *        a consumer that will call methods on {@link JobDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDriver(JobDriver)
         */
        default Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return jobDriver(JobDriver.builder().applyMutation(jobDriver).build());
        }

        /**
         * <p>
         * The configuration overrides for the job run.
         * </p>
         * 
         * @param configurationOverrides
         *        The configuration overrides for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationOverrides(ConfigurationOverrides configurationOverrides);

        /**
         * <p>
         * The configuration overrides for the job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationOverrides.Builder} avoiding
         * the need to create one manually via {@link ConfigurationOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationOverrides.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationOverrides(ConfigurationOverrides)}.
         * 
         * @param configurationOverrides
         *        a consumer that will call methods on {@link ConfigurationOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationOverrides(ConfigurationOverrides)
         */
        default Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return configurationOverrides(ConfigurationOverrides.builder().applyMutation(configurationOverrides).build());
        }

        /**
         * <p>
         * The tags assigned to job runs.
         * </p>
         * 
         * @param tags
         *        The tags assigned to job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The job template ID to be used to start the job run.
         * </p>
         * 
         * @param jobTemplateId
         *        The job template ID to be used to start the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateId(String jobTemplateId);

        /**
         * <p>
         * The values of job template parameters to start a job run.
         * </p>
         * 
         * @param jobTemplateParameters
         *        The values of job template parameters to start a job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateParameters(Map<String, String> jobTemplateParameters);

        /**
         * <p>
         * The retry policy configuration for the job run.
         * </p>
         * 
         * @param retryPolicyConfiguration
         *        The retry policy configuration for the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryPolicyConfiguration(RetryPolicyConfiguration retryPolicyConfiguration);

        /**
         * <p>
         * The retry policy configuration for the job run.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryPolicyConfiguration.Builder}
         * avoiding the need to create one manually via {@link RetryPolicyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryPolicyConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #retryPolicyConfiguration(RetryPolicyConfiguration)}.
         * 
         * @param retryPolicyConfiguration
         *        a consumer that will call methods on {@link RetryPolicyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryPolicyConfiguration(RetryPolicyConfiguration)
         */
        default Builder retryPolicyConfiguration(Consumer<RetryPolicyConfiguration.Builder> retryPolicyConfiguration) {
            return retryPolicyConfiguration(RetryPolicyConfiguration.builder().applyMutation(retryPolicyConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String name;

        private String virtualClusterId;

        private String clientToken;

        private String executionRoleArn;

        private String releaseLabel;

        private JobDriver jobDriver;

        private ConfigurationOverrides configurationOverrides;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String jobTemplateId;

        private Map<String, String> jobTemplateParameters = DefaultSdkAutoConstructMap.getInstance();

        private RetryPolicyConfiguration retryPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartJobRunRequest model) {
            super(model);
            name(model.name);
            virtualClusterId(model.virtualClusterId);
            clientToken(model.clientToken);
            executionRoleArn(model.executionRoleArn);
            releaseLabel(model.releaseLabel);
            jobDriver(model.jobDriver);
            configurationOverrides(model.configurationOverrides);
            tags(model.tags);
            jobTemplateId(model.jobTemplateId);
            jobTemplateParameters(model.jobTemplateParameters);
            retryPolicyConfiguration(model.retryPolicyConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVirtualClusterId() {
            return virtualClusterId;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return jobDriver != null ? jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return configurationOverrides != null ? configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getJobTemplateId() {
            return jobTemplateId;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        @Override
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final Map<String, String> getJobTemplateParameters() {
            if (jobTemplateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return jobTemplateParameters;
        }

        public final void setJobTemplateParameters(Map<String, String> jobTemplateParameters) {
            this.jobTemplateParameters = TemplateParameterInputMapCopier.copy(jobTemplateParameters);
        }

        @Override
        public final Builder jobTemplateParameters(Map<String, String> jobTemplateParameters) {
            this.jobTemplateParameters = TemplateParameterInputMapCopier.copy(jobTemplateParameters);
            return this;
        }

        public final RetryPolicyConfiguration.Builder getRetryPolicyConfiguration() {
            return retryPolicyConfiguration != null ? retryPolicyConfiguration.toBuilder() : null;
        }

        public final void setRetryPolicyConfiguration(RetryPolicyConfiguration.BuilderImpl retryPolicyConfiguration) {
            this.retryPolicyConfiguration = retryPolicyConfiguration != null ? retryPolicyConfiguration.build() : null;
        }

        @Override
        public final Builder retryPolicyConfiguration(RetryPolicyConfiguration retryPolicyConfiguration) {
            this.retryPolicyConfiguration = retryPolicyConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartJobRunRequest build() {
            return new StartJobRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
