/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualClustersResponse extends EmrContainersResponse implements
        ToCopyableBuilder<ListVirtualClustersResponse.Builder, ListVirtualClustersResponse> {
    private static final SdkField<List<VirtualCluster>> VIRTUAL_CLUSTERS_FIELD = SdkField
            .<List<VirtualCluster>> builder(MarshallingType.LIST)
            .memberName("virtualClusters")
            .getter(getter(ListVirtualClustersResponse::virtualClusters))
            .setter(setter(Builder::virtualClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualCluster> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualCluster::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_CLUSTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VirtualCluster> virtualClusters;

    private final String nextToken;

    private ListVirtualClustersResponse(BuilderImpl builder) {
        super(builder);
        this.virtualClusters = builder.virtualClusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualClusters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualClusters() {
        return virtualClusters != null && !(virtualClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This output lists the specified virtual clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualClusters} method.
     * </p>
     * 
     * @return This output lists the specified virtual clusters.
     */
    public final List<VirtualCluster> virtualClusters() {
        return virtualClusters;
    }

    /**
     * <p>
     * This output displays the token for the next set of virtual clusters.
     * </p>
     * 
     * @return This output displays the token for the next set of virtual clusters.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualClusters() ? virtualClusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualClustersResponse)) {
            return false;
        }
        ListVirtualClustersResponse other = (ListVirtualClustersResponse) obj;
        return hasVirtualClusters() == other.hasVirtualClusters() && Objects.equals(virtualClusters(), other.virtualClusters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualClustersResponse")
                .add("VirtualClusters", hasVirtualClusters() ? virtualClusters() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualClusters":
            return Optional.ofNullable(clazz.cast(virtualClusters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualClustersResponse, T> g) {
        return obj -> g.apply((ListVirtualClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVirtualClustersResponse> {
        /**
         * <p>
         * This output lists the specified virtual clusters.
         * </p>
         * 
         * @param virtualClusters
         *        This output lists the specified virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusters(Collection<VirtualCluster> virtualClusters);

        /**
         * <p>
         * This output lists the specified virtual clusters.
         * </p>
         * 
         * @param virtualClusters
         *        This output lists the specified virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusters(VirtualCluster... virtualClusters);

        /**
         * <p>
         * This output lists the specified virtual clusters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emrcontainers.model.VirtualCluster.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.emrcontainers.model.VirtualCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emrcontainers.model.VirtualCluster.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualClusters(List<VirtualCluster>)}.
         * 
         * @param virtualClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emrcontainers.model.VirtualCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualClusters(java.util.Collection<VirtualCluster>)
         */
        Builder virtualClusters(Consumer<VirtualCluster.Builder>... virtualClusters);

        /**
         * <p>
         * This output displays the token for the next set of virtual clusters.
         * </p>
         * 
         * @param nextToken
         *        This output displays the token for the next set of virtual clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EmrContainersResponse.BuilderImpl implements Builder {
        private List<VirtualCluster> virtualClusters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualClustersResponse model) {
            super(model);
            virtualClusters(model.virtualClusters);
            nextToken(model.nextToken);
        }

        public final List<VirtualCluster.Builder> getVirtualClusters() {
            List<VirtualCluster.Builder> result = VirtualClustersCopier.copyToBuilder(this.virtualClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualClusters(Collection<VirtualCluster.BuilderImpl> virtualClusters) {
            this.virtualClusters = VirtualClustersCopier.copyFromBuilder(virtualClusters);
        }

        @Override
        public final Builder virtualClusters(Collection<VirtualCluster> virtualClusters) {
            this.virtualClusters = VirtualClustersCopier.copy(virtualClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualClusters(VirtualCluster... virtualClusters) {
            virtualClusters(Arrays.asList(virtualClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualClusters(Consumer<VirtualCluster.Builder>... virtualClusters) {
            virtualClusters(Stream.of(virtualClusters).map(c -> VirtualCluster.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVirtualClustersResponse build() {
            return new ListVirtualClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
