/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration for CloudWatch monitoring. You can configure your jobs to send log information to CloudWatch Logs.
 * This data type allows job template parameters to be specified within.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParametricCloudWatchMonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParametricCloudWatchMonitoringConfiguration.Builder, ParametricCloudWatchMonitoringConfiguration> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(ParametricCloudWatchMonitoringConfiguration::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamNamePrefix").getter(getter(ParametricCloudWatchMonitoringConfiguration::logStreamNamePrefix))
            .setter(setter(Builder::logStreamNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamNamePrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_STREAM_NAME_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroupName;

    private final String logStreamNamePrefix;

    private ParametricCloudWatchMonitoringConfiguration(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamNamePrefix = builder.logStreamNamePrefix;
    }

    /**
     * <p>
     * The name of the log group for log publishing.
     * </p>
     * 
     * @return The name of the log group for log publishing.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The specified name prefix for log streams.
     * </p>
     * 
     * @return The specified name prefix for log streams.
     */
    public final String logStreamNamePrefix() {
        return logStreamNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamNamePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametricCloudWatchMonitoringConfiguration)) {
            return false;
        }
        ParametricCloudWatchMonitoringConfiguration other = (ParametricCloudWatchMonitoringConfiguration) obj;
        return Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(logStreamNamePrefix(), other.logStreamNamePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParametricCloudWatchMonitoringConfiguration").add("LogGroupName", logGroupName())
                .add("LogStreamNamePrefix", logStreamNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logStreamNamePrefix":
            return Optional.ofNullable(clazz.cast(logStreamNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParametricCloudWatchMonitoringConfiguration, T> g) {
        return obj -> g.apply((ParametricCloudWatchMonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParametricCloudWatchMonitoringConfiguration> {
        /**
         * <p>
         * The name of the log group for log publishing.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group for log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The specified name prefix for log streams.
         * </p>
         * 
         * @param logStreamNamePrefix
         *        The specified name prefix for log streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamNamePrefix(String logStreamNamePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametricCloudWatchMonitoringConfiguration model) {
            logGroupName(model.logGroupName);
            logStreamNamePrefix(model.logStreamNamePrefix);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamNamePrefix() {
            return logStreamNamePrefix;
        }

        public final void setLogStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
        }

        @Override
        public final Builder logStreamNamePrefix(String logStreamNamePrefix) {
            this.logStreamNamePrefix = logStreamNamePrefix;
            return this;
        }

        @Override
        public ParametricCloudWatchMonitoringConfiguration build() {
            return new ParametricCloudWatchMonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
